typedef struct fibT fibT,*fibP;
typedef struct fibElementT fibElementT,*fibElementP;

/*
 * Creates an empty fibonacci heap
 */
fibP fibNew();

/*
 * Returns the number of elements in a fibonacci heap
 */
int fibLen(fibP fib);

/*
 * Returns priority of element
 */
unsigned long fibPriority(fibElementP el);

/*
 * Returns data of element
 */
void *fibData(fibElementP el);

/*
 * Inserts data with priority into fibonacci heap
 * (returns a pointer to the element, which is neccessary to call
 *  IncreasePriority later.)
 */
fibElementP fibInsert(fibP heap,unsigned long priority,void *data);


/* 
 * Merges two fibonacci heaps.
 * the second heap (q2) will be freed.
 */
void fibMerge(fibP q1,fibP q2);

/*
 * Increases Priority of en element
 * Implements cascading cuts.
 */
void fibIncreasePriority(fibP heap,fibElementP el,unsigned long newPrio);

/*
 * finds, returns and deletes maximum
 * from fibonacci heap
 */
void fibDeleteMax(fibP heap,unsigned long *priority,void **data);
