#include <stdio.h>
#include <stdlib.h>
#include "graph.h"

struct grEdgeT
{
  unsigned int weight;
  grEdgeP startNext;
  grEdgeP endNext;
  grEdgeP allNext;
  int start,end;
};

struct grGraphT
{
  int len;
  int m;
  grEdgeP *nodes;
  grEdgeP edges;
};

static void grInsertEdge(grGraphP graph,grEdgeP edge)
{
  edge->allNext=graph->edges;
  graph->edges=edge;
  
  edge->startNext=graph->nodes[edge->start];
  graph->nodes[edge->start]=edge;
  
  edge->endNext=graph->nodes[edge->end];
  graph->nodes[edge->end]=edge; 
}

static grEdgeP grNewEdge(int start,int end,unsigned int weight)
{
  grEdgeP res;
  res=(grEdgeP)malloc(sizeof(grEdgeT));
  res->weight=weight;
  res->start=start;
  res->end=end;
  return res;
}

grGraphP grNew(int n)
{
  int i;
  grGraphP res;
  
  res=(grGraphP)malloc(sizeof(grGraphT));
  res->len=n;
  res->m=0;
  res->nodes=(grEdgeP *)malloc(sizeof(grEdgeP)*n);
  for(i=0;i<n;i++)
    res->nodes[i]=NULL;
    
  return res;
}

int grLen(grGraphP graph)
{
  return graph->len;
}

void grAddEdge(grGraphP graph,int n1,int n2,unsigned int weight)
{
  grEdgeP e;
  e=grNewEdge(n1,n2,weight);
  grInsertEdge(graph,e);
  graph->m++;
}

grEdgeP grEdges(grGraphP graph,int node)
{
  return graph->nodes[node];
}

grEdgeP grNextEdge(int node,grEdgeP edge)
{
  if (node==edge->start) return edge->startNext;
  if (node==edge->end) return edge->endNext;
  return NULL;
}

unsigned int grWeight(grEdgeP edge)
{
  return edge->weight;
}

int grAdjacent(int node,grEdgeP edge)
{
   if (node==edge->start) return edge->end;
   if (node==edge->end) return edge->start;
   return -1;
}


grGraphP grReadFromFP(FILE *fp,int *start,int *end)
{
  int n,m,i,n1,n2;
  unsigned int w;
  grGraphP res;
  char buf[100],*h;
  
  fgets(buf,90,fp);
  n=strtol(buf,NULL,10);
  
  fgets(buf,90,fp);
  m=strtol(buf,NULL,10);
  
  fgets(buf,90,fp);
  *start=strtol(buf,&h,10);
  *end=strtol(h,NULL,10);

  printf("Graph has %d nodes and %d edges\n",n,m);
  res=grNew(n);
  for (i=0;i<m;i++)
  {
    fgets(buf,90,fp);
    n1=strtol(buf,&h,10);
    n2=strtol(h,&h,10);
    w=strtoul(h,NULL,10);
    grAddEdge(res,n1,n2,w);
  }
  return res;
}

grGraphP grReadFromFile(char *name,int *start,int *end)
{
  FILE *fp;
  grGraphP res;
  fp=fopen(name,"r");
  res=grReadFromFP(fp,start,end);  
  fclose(fp);
  return res;
}

void grWriteToFile(char *name,grGraphP graph)
{
  FILE *fp;
  grEdgeP edge;
  fp=fopen(name,"w");
  if (fp==NULL) return;
  fprintf(fp,"%d\n",graph->len);
  fprintf(fp,"%d\n",graph->m);
  edge=graph->edges;
  while (edge!=NULL)
  {
    fprintf(fp,"%d %d %d\n",edge->start,edge->end,edge->weight);
    edge=edge->allNext;
  }
  fclose(fp);
}

