/**************************************
 *  A simple graph model              *
 *  only adding of edges is possible  *
 **************************************/
 
typedef struct grGraphT *grGraphP,grGraphT;
typedef struct grEdgeT *grEdgeP,grEdgeT;

/*
 * Creates a graph with n nodes
 */
grGraphP grNew(int n);

/*
 * Returns the number of nodes
 */
int grLen(grGraphP graph);

/*
 * Adds an edge to the graph
 */
void grAddEdge(grGraphP graph,int n1,int n2,unsigned int weight);

/*
 * gets the first edge of a node.
 * use grNextEdge to get the next edge.
 */
grEdgeP grEdges(grGraphP graph,int node);

/* 
 * gets the next edge of the node.
 */
grEdgeP grNextEdge(int node,grEdgeP edge);

/*
 * gets the weight of the edge
 */
unsigned int grWeight(grEdgeP edge);

/*
 * gets the adjacent node to node on edge
 */
int grAdjacent(int node,grEdgeP edge);

/*
 * Reads graph from file pointer
 */
grGraphP grReadFromFP(FILE *fp,int *start,int *end);

/*
 * Reads the graph from a file
 */
grGraphP grReadFromFile(char *name,int *start,int *end);

/*
 * Writes the graph to a file
 */
void grWriteToFile(char *name,grGraphP graph);
