typedef struct rdxElementT rdxElementT,*rdxElementP;
typedef struct rdxT rdxT,*rdxP;

/* 
  A radix heap only works, if a monotonic criteria is met:
  After a DeleteMin no element will get a priority smaller
  than the priority of the deleted minimum. (This means
  you may NOT insert new elements with smaller priority,
  and you may NOT decrease elements to smaller priority).
*/

rdxP rdxNew();
int rdxLen(rdxP heap);
unsigned int rdxPriority(rdxElementP el);
void *rdxData(rdxElementP el);
rdxElementP rdxInsert(rdxP heap,unsigned int priority,void *data);
void rdxDecreasePriority(rdxP heap,rdxElementP el,unsigned int newPrio);
void rdxDeleteMin(rdxP heap,unsigned int *priority,void **data);
