#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "graph.h"
#include "rdx.h"

static rdxElementP *nodeToHeap;
static unsigned int *distance;
static char *finished;
static void initArrays(int n)
{
  int i;
  
  nodeToHeap=(rdxElementP *)malloc(sizeof(rdxElementP)*n);
  distance=(unsigned int *)malloc(sizeof(unsigned int)*n);
  finished=(char *)malloc(n);
  for (i=0;i<n;i++)
  {
    distance[i]=-1;
    finished[i]=0;
    nodeToHeap[i]=NULL;
  }
}

void dijkstra(grGraphP graph,int n,int z)
{
  int node,adj;
  grEdgeP edge;
  rdxP pq;
  rdxElementP pqEl;
  unsigned int dist,d,newDist,maxDist;
    
  initArrays(grLen(graph));
	pq=rdxNew();
	nodeToHeap[n]=rdxInsert(pq,0,(void *)n);
	distance[n]=0;
	
	maxDist=0;
	while (rdxLen(pq)>0)
	{
	  rdxDeleteMin(pq,&dist,(void **)(&node));
	  finished[node]=1;
	  distance[node]=dist;
	  if (node==z) break;
	  edge=grEdges(graph,node);
	  while (edge!=NULL)
	  {	  
	    adj=grAdjacent(node,edge);
	    if (finished[adj]==0)
	    {
	      newDist=dist+grWeight(edge);
	      pqEl=nodeToHeap[adj];
	      if (pqEl!=NULL)
	      {
	        d=rdxPriority(pqEl);
	        if (newDist == d) printf("Ambigious way to %d\n",adj);
  	      if (newDist < d)
  	        rdxDecreasePriority(pq,pqEl,newDist);
  	    }
  	    else
  	      nodeToHeap[adj]=rdxInsert(pq,newDist,(void *)adj);
  	  }
  	  edge=grNextEdge(node,edge);
  	}
  }
}

unsigned long dijGetDist(int n)
{
  return distance[n];
}

int main()
{
  grGraphP graph;
  int sk,ek;  
  clock_t start,end;

  graph=grReadFromFP(stdin,&sk,&ek);
  printf("Finding paths\n");
  start=clock();
  dijkstra(graph,sk,ek);
  end=clock();
  printf("Found path\n");
  printf("time : %.2f s\n",(double)(end-start)/CLOCKS_PER_SEC);
  printf("Distance from %d to %d : %ld\n",sk,ek,dijGetDist(ek));
  return 0;
}
  