#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "graph.h"
#include "kbuck.h"

static kbuckElementP *nodeToHeap;
static unsigned int *distance;
static char *finished;
static void initArrays(int n)
{
  int i;
  
  nodeToHeap=(kbuckElementP *)malloc(sizeof(kbuckElementP)*n);
  distance=(unsigned int *)malloc(sizeof(unsigned int)*n);
  finished=(char *)malloc(n);
  for (i=0;i<n;i++)
  {
    distance[i]=-1;
    finished[i]=0;
    nodeToHeap[i]=NULL;
  }
}

void dijkstra(grGraphP graph,int n,int z)
{
  int node,adj;
  grEdgeP edge;
  kbuckP pq;
  kbuckElementP pqEl;
  unsigned int dist,d,newDist,maxDist;
    
  initArrays(grLen(graph));
	pq=kbuckNew();
	nodeToHeap[n]=kbuckInsert(pq,0,(void *)n);
	distance[n]=0;
	
	maxDist=0;
	while (kbuckLen(pq)>0)
	{
	  kbuckDeleteMin(pq,&dist,(void **)(&node));
	  finished[node]=1;
	  distance[node]=dist;
	  if (node==z) break;
	  edge=grEdges(graph,node);
	  while (edge!=NULL)
	  {	  
	    adj=grAdjacent(node,edge);
	    if (finished[adj]==0)
	    {
	      newDist=dist+grWeight(edge);
	      pqEl=nodeToHeap[adj];
	      if (pqEl!=NULL)
	      {
	        d=kbuckPriority(pqEl);
	        if (newDist == d) printf("Ambigious way to %d\n",adj);
  	      if (newDist < d)
  	        kbuckDecreasePriority(pq,pqEl,newDist);
  	    }
  	    else
  	      nodeToHeap[adj]=kbuckInsert(pq,newDist,(void *)adj);
  	  }
  	  edge=grNextEdge(node,edge);
  	}
  }
}

unsigned long dijGetDist(int n)
{
  return distance[n];
}

int main()
{
  grGraphP graph;
  int sk,ek;  
  clock_t start,end;

  graph=grReadFromFP(stdin,&sk,&ek);
  printf("Finding paths\n");
  start=clock();
  dijkstra(graph,sk,ek);
  end=clock();
  printf("Found path\n");
  printf("time : %.2f s\n",(double)(end-start)/CLOCKS_PER_SEC);
  printf("Distance from %d to %d : %ld\n",sk,ek,dijGetDist(ek));
  return 0;
}
