public class Bucket
{
  DoubleLinkedList elements;
  int minBound;
  int number;
  
  public Bucket(int m,int n)
  {
    minBound=m;
    number=n;
    elements=new DoubleLinkedList();
  }
  
  public void add(BucketElement e)
  {
    elements.add(e);
    e.setBucket(number);
  }
  
  public void remove(BucketElement e)
  {
    elements.remove(e);
  }
  
  public BucketElement extractMin()
  {
    BucketElement minEl,el;
    int minKey;
    
    minEl=(BucketElement)elements.getHead();
    if (minEl == null) return null;
    
    minKey=minEl.getKey();
    
    el=(BucketElement)minEl.getNext();
    
    while (el!=null)
    {
      if (el.getKey() < minKey)
      {
        minKey=el.getKey();
        minEl=el;
      }
      el=(BucketElement)el.getNext();
    }
    elements.remove(minEl);
    return minEl;
  }
  
  public int getMinBound()
  {
    return minBound;
  }
  
  public void setMinBound(int m)
  {
    minBound=m;
  }
  
  public void makeEmpty()
  {
    elements.makeEmpty();
  }
  
  public BucketElement getFirstElement()
  {
    return (BucketElement)elements.getHead();
  }
  
  public boolean isEmpty()
  {
    return elements.isEmpty();
  }
}
