import java.io.*;

public class Dijkstra
{
  static int minPath(Graph g)
  {
    RadixHeap heap;
    BucketElement el;
    BucketElement nodeToEl[];
    int dist[];
    int i,maxNode,node,adj,d,w,start,end;
    Edge e;
    
    start=g.getStart();
    end=g.getEnd();
    maxNode=g.getMaxNode();
    heap=new RadixHeap(31);
     
    nodeToEl=new BucketElement[maxNode];
    dist=new int[maxNode]; 
    for (i=0;i<maxNode;i++)
    {
      nodeToEl[i]=null;
      dist[i]=-1;
    }
    
    el=new BucketElement(start,0);
    nodeToEl[start]=el;
    heap.insert(el);
    
    while (heap.getSize()>0)
    {
      el=heap.extractMin();
      node=el.getNodeNumber();
      dist[node]=el.getKey();
      d=dist[node];
      el=null;
      if (node==end) return d;
      
      e=g.getNode(node).getFirstEdge();
      while (e!=null)
      {
        adj=e.getEnd();
        w=e.getWeight();
        if (dist[adj]<0)
        {
          dist[adj]=d+w;
          el=new BucketElement(adj,d+w);
          nodeToEl[adj]=el;
          heap.insert(el);
        }
        else
        {
          if (dist[adj]>d+w)
          {
            dist[adj]=d+w;
            heap.decreaseKey(nodeToEl[adj],d+w);
          }
        }
        e=(Edge)e.getNext();
      }
    }
    return -1;
  }
  
  static void main(String args[]) throws IOException
  {
    Graph g;
    int l;
    if (args.length!=1)
    {
      System.out.println("Usage: java Dijkstra <graph>");
      return;
    }
    System.out.println("Reading "+args[0]);
    g=new Graph(args[0]);
    System.out.println("Calculating minimum path from " + 
                        g.getStart()+ " to " + g.getEnd());
    l=minPath(g);
    System.out.println("Length of path : " + l);
  }
}
