import java.io.*;
import java.util.StringTokenizer;

public class Graph
{
  int maxNode;
  Node nodes[];
  int start,end;
  
  public Graph(int n)
  {
    int i;
    start=0;
    end=n-1;
    maxNode=n;
    nodes=new Node[n];
    for (i=0;i<n;i++)
      nodes[i]=new Node(i);

  }
    
  public void addEdge(int n1,int n2,int w)
  {
    Edge e1,e2;
    e1=new Edge(n1,n2,w);
    e2=new Edge(n2,n1,w);
    nodes[n1].addEdge(e1);
    nodes[n2].addEdge(e2);
  }

  public Graph(String name) throws IOException
  {
    BufferedReader input;
    String textline;
    StreamTokenizer tokenizer;
    int m,i,n1,n2,w;
    
    tokenizer = new StreamTokenizer(new FileReader(name));
    tokenizer.eolIsSignificant(false);
    tokenizer.parseNumbers();
    
    tokenizer.nextToken();
    maxNode=(int)tokenizer.nval;
    tokenizer.nextToken();
    m=(int)tokenizer.nval;
    System.out.println(" n : " + maxNode + " m : " + m);
    
    nodes=new Node[maxNode];
    for (i=0;i<maxNode;i++)
      nodes[i]=new Node(i);
    
    tokenizer.nextToken();
    start=(int)tokenizer.nval;
    tokenizer.nextToken();
    end=(int)tokenizer.nval;
    System.out.println("Start: " + start + " End: " + end);
    
    for (i=0;i<m;i++)
    {
      tokenizer.nextToken();
      n1=(int)tokenizer.nval;
      tokenizer.nextToken();
      n2=(int)tokenizer.nval;
      tokenizer.nextToken();
      w=(int)tokenizer.nval;
      addEdge(n1,n2,w);
/* Java is a little slow when objects have to be created.
   If you want to watch, uncomment the following */
/*      System.out.println("Added Edge "+i); */
    }
  }
  
  public Node getNode(int i)
  {
    return nodes[i];
  }
  
  public int getMaxNode()
  {
    return maxNode;
  }
  
  public int getStart()
  {
    return start;
  }
  
  public int getEnd()
  {
    return end;
  }
  
  static public void main(String args[]) throws IOException
  {
    Graph g;
    g = new Graph("test.txt");
  }
}
