public class RadixHeap
{
  Bucket buckets[];
  int maxBucket;
  int size;
  
  public RadixHeap(int m)
  {
    int b,i;
    
    maxBucket=m;
    buckets=new Bucket[maxBucket];
    size=0;
    
    buckets[0]=new Bucket(0,0);
    
    b=1;
    for (i=1;i<maxBucket;i++)
    {
      buckets[i]=new Bucket(b,i);
      b=b*2;
    }
  }
  
  public int getSize()
  {
    return size;
  }
  
  public void insert(BucketElement el)
  {
    int i;
    int k;
    size++;
    i=maxBucket-1;
    k=el.getKey();
    while (buckets[i].getMinBound() > k) i--;
    buckets[i].add(el);
  }
  
  private void insertFromBucket(BucketElement el,int b)
  {
    int i;
    int k;
    i=b;
    k=el.getKey();
    while (buckets[i].getMinBound() > k) i--;
    buckets[i].add(el);
  }
     
  public void decreaseKey(BucketElement el,int newKey)
  {
    int b;
    b=el.getBucket();
    buckets[b].remove(el);
    el.setKey(newKey);
    insertFromBucket(el,b);
  }

  public BucketElement extractMin()
  {
    int i,j;
    int k,b;
    BucketElement min;
    BucketElement el,nel;
    
    i=0;
    while (buckets[i].isEmpty()) i++;
    
    if (i>1)
      min=buckets[i].extractMin();
    else
    {
      min=buckets[i].getFirstElement();
      buckets[i].remove(min);
    }
    
    if (i>0)
    {
      k=min.getKey();
      buckets[0].setMinBound(k);
      b=1;
      for (j=1;j<=i;j++)
      {
        buckets[j].setMinBound(k+b);
        b=b*2;
      }
      
      el=buckets[i].getFirstElement();
      buckets[i].makeEmpty();
      
      while (el!=null)
      {
        nel=(BucketElement)el.getNext();
        insertFromBucket(el,i-1);
        el=nel;
      }
    }
    size--;
    return min;
  }

  /*
   * A main routine which tests the radix heap.
   */  
  public static void main(String args[])
  {
    BucketElement myEls[],el;
    RadixHeap heap;
    int i,c,j,h;
    
    myEls=new BucketElement[1000];
    heap=new RadixHeap(31);
    System.out.println("Insert");
    for (i=0;i<600;i+=2)
    {
      el=new BucketElement(0,i);
      heap.insert(el);
      myEls[i]=el;
    }
    for (i=1;i<600;i+=2)
    {
      el=new BucketElement(0,i);
      heap.insert(el);
      myEls[i]=el;
    }
    System.out.println("Ok");
    System.out.println("Insert + ExtraceMin");
    c=0;h=600;
    while (c<250)
    {
      el=heap.extractMin();
      if (c!=el.getKey())
      {
        System.out.println("Wrong key : should be " + c + " is " + el.getKey());
        return;
      }
      if (h<900)
      {
        el=new BucketElement(0,h);
        heap.insert(el);
        myEls[h]=el;
        h++;
        el=new BucketElement(0,h);
        heap.insert(el);
        myEls[h]=el;
        h++;
      }
      c++;
    }
    System.out.println("Ok");
    System.out.println("DecreaseKey");
    for (i=500;i<800;i+=2)
    {
      heap.decreaseKey(myEls[i],i/2);
    }
    for (i=501;i<800;i+=2)
    {
      heap.decreaseKey(myEls[i],i/2);
    }
    System.out.println("Ok");
    System.out.println("DecreaseKey + Insert + ExtraceMin");
    c=250;j=0;h=800;
    while (heap.getSize()>0)
    {
      el=heap.extractMin();
      if (c!=el.getKey())
      {
        System.out.println("Wrong key : should be " + c + " is " + el.getKey());
        return;
      }
      if (h<1000)
      {
        heap.decreaseKey(myEls[h],h/2);
        if (h<900)
        {
          el=new BucketElement(0,h+100);
          heap.insert(el);
          myEls[h+100]=el;
        }
        h++;
      }
      j++;
      if (j==3)
      {
        j=0;
        c++;
      }
    }
    System.out.println("Ok");
  }
}
