package Blatt6;

import java.util.Date;
import java.util.Random;

import javax.swing.JLabel;


/**
 * AlphaBeta-Player
 * @author Stefan Pfingstl
 */
public class AlphaBetaPlayer extends Player {
	Random rand = new Random(new Date().getTime() + player * 250);
	boolean firstPlay = true;

	public AlphaBetaPlayer(GamePanel game, int player, JLabel status) {
		super(game, player, status);
		name = "Alpha-Beta Player " + player;
	}

	public void play() {
		try {
			Thread.sleep(VierGewinnt.WAIT);
		} catch (Exception e) {
		}

		int cols[] = game.getPossibleCols();

		// den ersten Stein in die Mitte
		if (firstPlay) {
			status.setText("Erster Zug in die Mitte...");
			if (game.getPosition(4, 0) == -1) {
				game.play(4, this.player);
			} else {
				game.play(3, this.player);
			}
			firstPlay = false;
			return;
		}

		int max = Integer.MIN_VALUE;
		int move = -1;
		int val;
		for (int i = 0; i < cols.length; i++) {

			// kann ich im naechsten Zug gewinnen
			game.testPlay(cols[i], player);
			if (game.isWinningPosition((this.player + 1) % 2)) {
				// dann ziehe
				max = 9999;
				move = cols[i];
				game.removeAllTestPlay();
				status.setText("Bewertung: " + max);
				break;
			}
			game.removeAllTestPlay();

			// kann der Gegner im naechsten Zug gewinnen
			game.testPlay(cols[i], (player + 1) % 2);
			if (game.isWinningPosition((this.player + 1) % 2)) {
				// dann verhindere den Zug des Gegeners
				max = 9999;
				move = cols[i];
				game.removeAllTestPlay();
				status.setText("Bewertung: " + max);
				break;
			}
			game.removeAllTestPlay();

			// ansonsten bestimme den besten Zug
			game.testPlay(cols[i], player);
			val = AlphaBeta(4, -9999, +9999, this.player, true);
			game.removeAllTestPlay();

			if (val > max) {
				max = val;
				move = cols[i];
			}
		}

		status.setText("Bewertung: " + max);
		game.removeAllTestPlay();
		game.play(move, this.player);
	}

	public void sleep(int time) {
		try {
			Thread.sleep(time);
		} catch (Exception e) {
		}
	}

	int AlphaBeta(
		int depth,
		int alpha,
		int beta,
		int player,
		boolean firstMove) {

		if (firstMove && game.isWinningPosition(this.player)) {
			return 999;
		}
		if (firstMove && game.isWinningPosition((this.player + 1) % 2)) {
			return 9999;
		}

		if (depth == 0) {
			return evaluateGame();
		}

		int cols[] = game.getPossibleCols();

		for (int i = 0; i < cols.length; i++) {

			game.testPlay(cols[i], player);
			int val =
				AlphaBeta(depth - 1, alpha, beta, (player + 1) % 2, false);
			game.removeTestPlay();

			if (player == this.player) {
				// Beta-Cut mglich?
				if (val >= beta)
					return val;
				// besseren Zug auf dieser Ebene gefunden?
				if (val > alpha) {
					alpha = val;
				}
			} else {
				// Alpha-Cut mglich?
				if (val <= alpha)
					return val;
				// besseren Zug auf dieser Ebene gefunden?
				if (val < beta) {
					beta = val;
				}
			}

		}

		//return alpha;
		return (player == this.player ? alpha : beta);

	}

	public int evaluateGame() {
		int ret;
		int gegner = (this.player + 1) % 2;

		ret = 0;
		int s0 = 0;
		int s1 = 0;
		int s01 = 0;
		int s11 = 0;

		// Anzahl 3er- und 2er-Ketten
		int i, j;
		for (i = 0; i < game.getCols(); i++) {
			for (j = 0; j < game.getRows(); j++) {
				if(canBe4(i, j, this.player)) {
					s0 += is4(i, j, this.player) * 8;
					s0 += is3(i, j, this.player) * 4;
					s0 += is2(i, j, this.player) * 2;
				}
				else {
					s0 += is4(i, j, this.player) * 4;
					s0 += is3(i, j, this.player) * 2;
					s0 += is2(i, j, this.player) * 1;
				}

				if(canBe4(i, j, player)) {
					s1 += is4(i, j, gegner) * 64;
					s1 += is3(i, j, gegner) * 4;
					s1 += is2(i, j, gegner) * 2;
				}
			}
		}

		ret = s0 -s1;

		return ret;
	}

	public boolean canBe4(int col, int row, int player) {
		int cols = game.getCols();
		int rows = game.getRows();
		int ret = 0;

		if ((game.getPosition(col, row) != player)
			|| (game.getPosition(col, row) != -1)) {
			return false;
		}

		try {
			if ((game.getPosition(col + 1, row) == player
				|| game.getPosition(col + 1, row) == -1)
				&& (game.getPosition(col + 2, row) == player
					|| game.getPosition(col + 2, row) == -1)
				&& (game.getPosition(col + 3, row) == player
					|| game.getPosition(col + 3, row) == -1))
			return true;
		} catch (Exception e) {
		}

		try {
			if ((game.getPosition(col, row + 1) == player
				|| game.getPosition(col, row + 1) == -1)
				&& (game.getPosition(col, row + 2) == player
					|| game.getPosition(col, row + 2) == -1)
				&& (game.getPosition(col, row + 3) == player
					|| game.getPosition(col, row + 3) == -1))
			return true;
		} catch (Exception e) {
		}

		try {
			if ((game.getPosition(col+1, row + 1) == player
				|| game.getPosition(col+1, row + 1) == -1)
				&& (game.getPosition(col+2, row + 2) == player
					|| game.getPosition(col+2, row + 2) == -1)
				&& (game.getPosition(col+3, row + 3) == player
					|| game.getPosition(col+3, row + 3) == -1))
			return true;
		} catch (Exception e) {
		}

		try {
			if ((game.getPosition(col-1, row + 1) == player
				|| game.getPosition(col-1, row + 1) == -1)
				&& (game.getPosition(col-2, row + 2) == player
					|| game.getPosition(col-2, row + 2) == -1)
				&& (game.getPosition(col-3, row + 3) == player
					|| game.getPosition(col-3, row + 3) == -1))
			return true;
		} catch (Exception e) {
		}

		return false;
	}

	public int is4(int col, int row, int player) {
		int cols = game.getCols();
		int rows = game.getRows();
		int ret = 0;

		if (game.getPosition(col, row) != player) {
			return 0;
		}

		try {
			if (game.getPosition(col + 1, row) == player
				&& game.getPosition(col + 2, row) == player
				&& game.getPosition(col + 3, row) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col, row + 1) == player
				&& game.getPosition(col, row + 2) == player
				&& game.getPosition(col, row + 3) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col + 1, row + 1) == player
				&& game.getPosition(col + 2, row + 2) == player
				&& game.getPosition(col + 2, row + 2) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col - 1, row + 1) == player
				&& game.getPosition(col - 2, row + 2) == player
				&& game.getPosition(col - 2, row + 2) == player)
				ret++;
		} catch (Exception e) {
		}

		return ret;
	}

	public int is3(int col, int row, int player) {
		int cols = game.getCols();
		int rows = game.getRows();
		int ret = 0;
		if (game.getPosition(col, row) != player) {
			return 0;
		}

		try {
			if (game.getPosition(col + 1, row) == player
				&& game.getPosition(col + 2, row) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col, row + 1) == player
				&& game.getPosition(col, row + 2) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col + 1, row + 1) == player
				&& game.getPosition(col + 2, row + 2) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col - 1, row + 1) == player
				&& game.getPosition(col - 2, row + 2) == player)
				ret++;
		} catch (Exception e) {
		}

		return ret;
	}

	public int is2(int col, int row, int player) {

		int cols = game.getCols();
		int rows = game.getRows();
		int ret = 0;
		if (game.getPosition(col, row) != player) {
			return 0;
		}

		try {
			if (game.getPosition(col + 1, row) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col, row + 1) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col + 1, row + 1) == player)
				ret++;
		} catch (Exception e) {
		}

		try {
			if (game.getPosition(col - 1, row - 1) == player)
				ret++;
		} catch (Exception e) {
		}

		return ret;
	}

	public String toString() {
		return "Alpha-Beta Player";
	}

	public void setGame(GamePanel game, int playerNr) {
		this.game = game;
		this.player = playerNr;
	}
}


