package Blatt6;

import java.util.Date;
import java.util.Random;

import javax.swing.JLabel;

/**
 * Der Defensiv-Player spielt folgendermassen: Kann er mit dem n&auml;chsten Zug eine Gewinnstellung erreichen, so macht er diesen.
 * Kann der Gegener im n&auml;nsten Zug eine Gewinnstellung erreichen, so versucht er, diesen Zug auszufuehren. 
 * Ansonsten w&uuml;rfelt er den n&auml;chsten Zug aus.
 * @author Stefan Pfingstl
 * 
 */
public class DefensivPlayer extends Player {
	Random rand = new Random(new Date().getTime() + player * 250);

	public DefensivPlayer(GamePanel game, int player, JLabel status) {
		super(game, player, status);
		name = "Defensiv Player " + player;
	}

	public void play() {
		status.setText("Berechne meinen Zug...");

		try {
			// Kann ich mit dem naechsten Zug gewinnen?
			for (int i = 0; i < game.getCols(); i++) {
				game.testPlay(i, player);
				if (game.isWinningPosition(player)) {
					status.setText("Ich gewinne :-)");
					game.removeAllTestPlay();
					game.play(i, player);
					return;
				}
				game.removeTestPlay();
			}

			// falls noch etwas drin ist...
			game.removeAllTestPlay();

			// Kann der Gegner mit dem naechsten Zug gewinnen?
			for (int i = 0; i < game.getCols(); i++) {
				game.testPlay(i, (player + 1) % 2);
				if (game.isWinningPosition((player + 1) % 2)) {
					status.setText("Ich verliere :-(");
					game.removeAllTestPlay();
					game.play(i, player);
					status.setText("Doch noch nicht");
					return;
				}
				game.removeTestPlay();
			}

			// falls noch etwas drin ist...
			game.removeAllTestPlay();
		} catch (Exception e) {
			e.printStackTrace();
		}

		int col = rand.nextInt(game.getCols() * 10) % game.getCols();
		while (game.play(col, player) < 0) {
			col = rand.nextInt(game.getCols() * 10) % game.getCols();
			status.setText("Setze in Spalte " + col);
		}

	}

	public String toString() {
		return "Defensiv Player";
	}

	public void setGame(GamePanel game, int playerNr) {
		this.game = game;
		this.player = playerNr;
	}

}

