package Blatt6;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Random;

import javax.swing.JLabel;

/**
 * Der Human-Player muss immer mit der Maus auf eine Spalte klicken, um einen Zug auszuf&uuml;hren. 
 * @author Stefan Pfingstl
 */
public class HumanPlayer extends Player implements MouseListener {

	Random rand = new Random(new Date().getTime() + 250);
	boolean moved = true;

	public HumanPlayer(GamePanel game, int player, JLabel status) {
		super(game, player, status);
		name = "Human Player " + player;
		if (game != null)
			game.addMouseListener(this);
	}

	public void setGame(GamePanel game, int playerNr) {
		this.game = game;
		if (game != null) {
			game.addMouseListener(this);
		}
		this.player = playerNr;
	}

	public void play() {
		moved = false;
		status.setText("Bitte klicken Sie auf eine Spalte des Spielfeldes...");

		try {
			while (!moved) {
				Thread.sleep(VierGewinnt.WAIT);
			}
		} catch (Exception e) {
		}

	}

	public String toString() {
		return "Human Player";
	}

	public void mouseClicked(MouseEvent e) {
		if (moved)
			return;

		int posx = e.getX() - game.getOffset();
		int posy = e.getY() - game.getOffset();

		int col = posx / game.getGridSize();
		posy = game.getRows() - 1 - posy / game.getGridSize();

		if (col >= 0
			&& col < game.getCols()
			&& (game.play(col, player) >= 0)) {
			moved = true;
		}
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mousePressed(MouseEvent e) {
	}

	public void mouseReleased(MouseEvent e) {
	}

}
