package Blatt6;

import java.awt.*;
import javax.swing.*;

/**
 * Das Hauptprogramm. Der Aufruf erfolgt mit folgenden Parametern:
 * <ul>
 *   <li>Anzahl der Spalten
 *   <li>Anzahl der Zeilen
 *   <li>Spieler 1
 *   <li>Spieler 2
 * </ul>
 * 
 * Als Spieler stehen zur Verf&uuml;gung:
 * <ul>
 *   <li>0: Human-Player
 *   <li>1: Random-Player
 *   <li>2: Defensiv-Player
 *   <li>3: AlphaBeta-Player
 *   <li>4: Your-Player
 * </ul>
 * Beim Aufruf ohne Parameter wird das Spiel auf einem 7x6 Feld mit AlphaBeta- vs. Human-Player gestartet.
 * @author Stefan Pfingstl
 */
public class VierGewinnt extends JFrame {

	private GamePanel game = null;
	private JLabel statusBar = new JLabel("Vier gewinnt");
	private JPanel top = new JPanel(new FlowLayout(FlowLayout.LEFT));
	private Thread thread;
	final static int WAIT = 500;
	private Player[] player0 = new Player[5];
	private Player[] player1 = new Player[5];

	public VierGewinnt(int cols, int rows, int p1, int p2) {
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setTitle("Vier gewinnt");

		game = new GamePanel(cols, rows);

		player0[0] = new HumanPlayer(game, 0, statusBar);
		player0[1] = new RandomPlayer(game, 0, statusBar);
		player0[2] = new DefensivPlayer(game, 0, statusBar);
		player0[3] = new AlphaBetaPlayer(game, 0, statusBar);
		player0[4] = new YourPlayer(game, 0, statusBar);

		player1[0] = new HumanPlayer(game, 1, statusBar);
		player1[1] = new RandomPlayer(game, 1, statusBar);
		player1[2] = new DefensivPlayer(game, 1, statusBar);
		player1[3] = new AlphaBetaPlayer(game, 1, statusBar);
		player1[4] = new YourPlayer(game, 1, statusBar);

		player0[p1].setGame(game, 0);
		game.setPlayer(player0[p1], 0);

		player1[p2].setGame(game, 1);
		game.setPlayer(player1[p2], 1);

		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(game, BorderLayout.CENTER);
		this.getContentPane().add(statusBar, BorderLayout.SOUTH);

		this.setSize(600, 400);
		centerWindow();
		this.setVisible(true);

		thread = new Thread(game);
		try {
			Thread.sleep(1000);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		thread.start();
	}

	private void centerWindow() {
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = this.getSize();
		if (frameSize.height > screenSize.height) {
			frameSize.height = screenSize.height;
		}
		if (frameSize.width > screenSize.width) {
			frameSize.width = screenSize.width;
		}
		this.setLocation(
			(screenSize.width - frameSize.width) / 2,
			(screenSize.height - frameSize.height) / 2);
	}

	public static void main(String[] args) {
		if (args.length < 4) {
			System.out.println("Usage: VierGewinnt cols rows Player1 Player2");
			System.out.println("    0: Human Player");
			System.out.println("    1: Random Player");
			System.out.println("    2: Defensive Player");
			System.out.println("    3: Alpha-Beta Player");
			System.out.println("    4: Your Player");
			System.out.println("Using defaults: 7 6 3 0");
			args = new String[4];
			args[0] = "7";
			args[1] = "6";
			args[2] = "3";
			args[3] = "0";
		}

		try {
			new VierGewinnt(
				Integer.parseInt(args[0]),
				Integer.parseInt(args[1]),
				Integer.parseInt(args[2]),
				Integer.parseInt(args[3]));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}




