#include <iostream>
#include "control.h" // Fernbedienung
#include <LEDA/graphwin.h>
#include <LEDA/color.h>
#include <LEDA/basic.h>
#include <LEDA/core/queue.h>
#include <LEDA/node_pq.h>
#include <LEDA/stream.h>


// using namespaces properly
using leda::graph;
using leda::node;
using leda::edge;
using leda::node_array;
using leda::edge_array;
using leda::user_label;
using leda::GraphWin;
using leda::red;
using leda::blue;
using leda::green;
using leda::yellow;
using leda::string;
using leda::queue;
using leda::node_pq;
using leda::string_istream;



// Implementierung des Dijkstr-Algorithmus
// Parameter:
//    s: Start-Knoten
//    s: Ziel-Knoten
//    g: zu durchsuchender Graph (als Referenz)
//    gw: Darstellungsfenster des Graphen (als Referenz)
//    edge_weights: Kantengewichte (Entfernungen zwischen den Knoten) (als Referenz)
//    anim: Soll die Suche animiert werden?
int dijkstra(node s, node t, graph &g, GraphWin &gw, edge_array<int> edge_weights, bool anim) {

  node_pq<int> q(g); // Priority-Queue in der die bisher "entdeckte" minimale Enfernung der Knoten gespeichert wird
  int max_val = 0; // Entfernungswert, der nie erreicht werden kann und ersetzt daher \infty
  edge e;
  forall_edges(e,g)
  {
    max_val+= edge_weights[e]; // Berechnung des maximalen Werts
  }
  max_val*=g.number_of_nodes();
  max_val++;
  
  node v;
  forall_nodes(v,g) // Alle Knoten in die PQ,
  {
    if(v!=s)
    {
      q.insert(v,max_val);
    }
  }
  q.insert(s,0); // nur den Start Knoten setzen wir schon auf "0"
  node w;
  int cur_dist;

  while(q.member(t) )//!q.empty()) // So lange das Ziel-Element in der PQ ist, machen wir etwas
  {
    v=q.find_min(); // nehme das Minimum
    cur_dist = q.inf(v); // speichere die aktuelle Distanz
    q.del(v); // entferne es aus der PQ
    if(anim)
    {
      gw.set_color(v,blue);
    }
    if(v== t) // wenn wir den Ziel-Knoten gefunden haben, koennen wir aufhoeren, da sich dann die Entfernung zu dem Knoten nicht mehr veraendern kann
    {
      return cur_dist;
    }
    
    forall_inout_edges(e,v) // Alle adjazenten Knoten ueberpruefen
    {
      w = g.opposite(e,v);
      if(q.member(w)) // Werte nur veraendern, wenn der Knoten noch in der PQ ist (ansonsten ist Min.-Wert schon gefunden)
      {
	      if(cur_dist + edge_weights[e] < q.inf(w)) // nur wenn es eine Verbesserung gibt updaten
	      { 
		q.decrease_p(w,cur_dist + edge_weights[e]); // neue Entfernung setzen
                if(anim)
                {
		  gw.set_color(w,red); // FX
	  	  gw.set_user_label(w, string("%d", q.inf(w)));
		  gw.redraw();
		  leda_wait(1.5);
		  gw.set_color(w,yellow);
                }
	      }
      }

    }
  }
  return -1;
}


// Haupt-Programm
int main(int argc, char *argv[]) {
    // Fenster der Gre 800 x 600 zur Graphendarstellung erzeugen
    GraphWin gw(800, 600);

    gw.display(); // Fenster auf den Bildschirm bringen
    create_control(); // "Fernbedienung" anzeigen
    gw.set_directed(false); // ungerichtete Darstellung (keine Pfeile an Kanten)
    if (argc > 1)    // falls Name als Parameter, Graph laden
        gw.read(argv[1]);

    gw.edit();   // in Editier-Modus gehen, bis der Benutzer "done" klickt

    // jetzt holen wir uns den Graphen, den der Benutzer eingegeben oder geladen hat
    graph &g = gw.get_graph();

    if (g.number_of_nodes() == 0) {  // Ende, wenn der Graph leer ist.
        gw.close(); destroy_control();
        exit(1);
    }

    // Nun zeigen wir fuer alle Knoten den dfsnum-Wert als User-Label an
    // sowie initialisieren den Graphen gelb.
    node v;
    forall_nodes(v, g) {
        gw.set_label_type(v, user_label);    // User-Label anzeigen (statt Index-Label)
        gw.set_user_label(v, string("%d", -1)); // User-Label auf dfsnum[v] setzen
        gw.set_color(v, yellow);
    }
    edge e;
    forall_edges(e, g)
        gw.set_color(e, yellow);


    edge_array<int> ew(g); // Kantengewichte aus den User-Labels laden
    forall_edges(e, g) 
    {
      string s = gw.get_user_label(e);
      string_istream I(s);
      I >> ew[e];
    }

    // jetzt lassen wir den Benutzer mit der Maus einen unbesuchten Knoten
    // auswhlen (wenn er danebenklickt, wird NULL zurckgeliefert),
    node s,t;
    while ((s = gw.read_node()) == NULL) ;

    while ((t = gw.read_node()) == NULL) ;

    // nun rufen wir den Dijkstr-Algorithmus auf
    std::cout << dijkstra(s, t, g, gw, ew, true) << std::endl; // und geben die Kuerzeste Entfernung auf der Konsole aus

    gw.acknowledge("Ready!"); // Dialogbox anzeigen und besttigen lassen
    gw.edit(); // nochmal in den Edit-Modus, zum Anschauen :)

    // Aufrumen und Ende
    gw.close();
    destroy_control();
    exit(0);
}

