
public class UIcArray implements UArray
{

	private int beta;
	private int alpha;
	private int w;
	private int n;
	private int n_smaller;
	private int n_larger;
	private int[] b;
	private int[] b_smaller;
	private int[] b_larger;

public UIcArray()
{
	n_larger=0;
	n_smaller=0;
	n=0;
	w=1;
	beta=2;
	alpha=4;
	b_smaller=new int[w]; // kleineres und groesseres Array zum vorzeitigen Speichern der Elemente (Das was wir sonst ueber Tokens verrechnen fuehren wir hier einfach direkt aus)
	b=new int[w];
	b_larger=new int[beta*w];
}

public int get(int i)
{
	assert(0<=i && i<n);
	return b[i];
}

public int size()
{
	return n;
}

public int length()
{
	return w;
}

public void push_back(int e)
{
	if(n==w)
	{
		reallocate(beta*n);
	}
	if(n_larger<n)
	{
		for(int ii=0;ii<beta/(beta-1) && n_larger<n;++ii) // Wir kopieren ausreichend, aber konstant viele Elemente, damit das groessere Array bei einer Reallokation gefuellt ist.
		{
			b_larger[n_larger]=b[n_larger];
			n_larger++;
		}
	}
	if(n_larger==n) // wenn die Fuellstaende gleich sind, muessen wir nur noch das neue Element updaten
	{
		b_larger[n]=e;
		n_larger++;
	}
	b[n]=e;
	++n;
}

public void pop_back()
{
	assert(n>0);
	if(n_smaller==n)
	{
		n_smaller--;
	}
	if(n_larger==n)
	{
		n_larger--;
	}
	--n;
	if(alpha*n_smaller<w)
	{
		for(int ii=0; ii<beta/(alpha-beta) && alpha*n_smaller<w;++ii) // hier kopieren wir immer ausreichend, aber konstant viele Elemente in das kleinere Array falls verkleinert wird.
		{
			b_smaller[n_smaller]=b[n_smaller];
			n_smaller++;
		}
	}
	if(alpha*n <= w && n>0)
	{
		reallocate(beta*n);
	}
}

private void reallocate(int new_w)
{
	if(new_w>w) // Vergroessern, oder Verkleinern?
	{
		int[] new_b=new int[beta*new_w];
		b_smaller=b; // Shift der Arrays. das Kleinste vergessen wir.
		b=b_larger;
		int ii=beta*new_w;
		b_larger=new int[beta*new_w];
		//Fuellstaende setzen
		n_smaller=n;
		n_larger=0;
	}
	else
	{
		int[] new_b=new int[new_w/beta]; 
		b_larger=b; // Shift der Arrays. Das Groesste vergessen wir
		b=b_smaller;
		b_smaller=new_b;
		n_smaller=0;
		n_larger=n;
	}
	w=new_w;
}

}
