public class UIQueue implements UQueue {

  private int head; // Anfang im Array
  private int count; // Anzahl der Elemente
  private boolean circulation;  // Wert zum behandeln eines "Overflows"
  private UIsArray Q;
    
  public UIQueue()
	{
 		count = 0;
	  head = 0; 
  	circulation = false;    
  	Q = new UIsArray();
  }
  
  public int size() 
	{   
	  return count;
  }

  public boolean isEmpty() 
	{
	  return (count==0);
  }

  public int first() 
	{  
	  if (!isEmpty())
		{
	    return Q.get(head);
		}
	  else 
		{
			return -1;
		}
  }

  public void pushBack(int e) 
	{
	  if (count==Q.length()) // Das Array wird geresized, wenn wir e eintragen
		{               
	    for (int j=0;j<=head-1;j++) // deshalb tragen wir alle Elemente vor dem ersten Element (Q[head])...
			{
     		Q.push_back(Q.get(j));  // am ende der Liste ein
			}
	    Q.push_back(e);  // und koennen dann einfach das neue Element hinten anhaengen
  	  circulation = false;
	  }
		else
		{    
    	if ((head+count)%Q.length()>=head && !circulation)  // sonst koennen wir das Element einfach "hinten" anhaengen
			{
	      Q.push_back(e);
			}
	    else // ausser das Ende der Queue ist am Array-Ende
			{
	      Q.set((head+count)%Q.length(),e);
			}
	  }
	  count++;
  }

  public void popFront() 
	{
	  if (!isEmpty())
		{
	    count--;    
	    head = ++head%Q.length(); // Anfangspositon updaten
  	  if (head==0) 
			{
				 circulation = true; 
			}
	  }
 	}
}

