import java.util.*;

public class GraphS implements IGraphS {

	ArrayList<INodeS> nodes;
	ArrayList<IEdgeS> edges;

	public GraphS() {
		nodes = new ArrayList<INodeS>();
		edges = new ArrayList<IEdgeS>();
	}

	public int insert(INodeS v) {
		nodes.add(v);
		v.setID(nodes.size() - 1);
		return nodes.size() - 1;
	}

	public int insert(IEdgeS e) {
		edges.add(e);
		e.from().addEdge(e);
		e.setID(edges.size() - 1);
		return edges.size() - 1;
	}

	public INodeS find(int k) {
		if (k < nodes.size()) {
			return nodes.get(k);
		} else {
			return null;
		}
	}

	public IEdgeS find(int i, int j) {
		INodeS f = find(i);
		INodeS t = find(j);
		if (f == null || t == null) {
			return null;
		}
		IEdgeS[] fedges = f.getOutEdges();
		for (int ii = 0; ii < fedges.length; ++ii) {
			if (fedges[ii].to() == t) {
				return fedges[ii];
			}
		}
		return null;
	}

	public int numberOfNodes() {
		return nodes.size();
	}

	public int numberOfEdges() {
		return edges.size();
	}
}
