
import java.util.*;

public class Graph implements IGraph
{
		// Handles werden ind aufsteigender Reihenfolge vergeben (ArrayList,....)

		ArrayList<INode> nodes;
		ArrayList<IEdge> edges;

		public Graph()
		{
			nodes=new ArrayList<INode>();
			edges=new ArrayList<IEdge>();
		}

		public int insert(INode v)
		{
			nodes.add(v);
			return nodes.size()-1;
		}

		public int insert(IEdge e)
		{
			edges.add(e);
			e.from().addEdge(e);
			return edges.size()-1;
		}


    public INode find(int k)
		{
			if(k<nodes.size())
			{
			 return nodes.get(k);
			}
			else
			{
				return null;
			}
		}
		
    public IEdge find(int i, int j)
		{
			INode f=find(i);
			INode t=find(j);
			if(f==null || t==null)
			{
				return null;
			}
			IEdge[] fedges=f.getOutEdges();
			for(int ii=0;ii<fedges.length;++ii)
			{
				if(fedges[ii].to()==t)
				{
					return fedges[ii];
				}
			}
			return null;
		}

		public void remove(int i, int j)
		{
			IEdge e=find(i,j);
			remove(e);
		}
		
		private void remove(IEdge e)
		{
			if(e!=null)
			{
				e.from().removeEdge(e);
				edges.set(edges.indexOf(e),null); // so bleiben handles korrekt
			}
		}

    public void remove(int j)
		{
			INode rem=find(j);
			if(rem!=null)
			{
				IEdge[] incident_edges=rem.getEdges();
				for(int ii=0;ii<incident_edges.length;++ii)
				{
					remove(incident_edges[ii]);
				}
				nodes.set(nodes.indexOf(rem),null); // so blieben handles erhalten
			}
		}

	
		public int numberOfNodes()
		{
			return nodes.size(); 
		}

		public int numberOfEdges()
		{
			return edges.size();
		}
}
