

import java.util.*;

public class Node implements INode
{
		private ArrayList<IEdge> edges;
		private ArrayList<INode> inn;
		private ArrayList<INode> outn;
		private int id;

		public Node()
		{
			 edges=new ArrayList<IEdge>();
			 inn=new ArrayList<INode>();
			 outn=new ArrayList<INode>();
		}
			
		// von Ihnen zu implementieren
		public void addEdge(IEdge e)
		{
			edges.add(e);
			if(e.to()!=this) // so wird die Kante auch beim Zielknoten korrekt eingetragen
			{
				e.to().addEdge(e);
				addEdgeTo(e.to());
			}
			else
			{
				addEdgeFrom(e.from());
			}
		}

		public void addEdgeTo(INode v) // okay nicht unbedingt sinnvoll ohne zusaetzliche Methoden 
		{
			outn.add(v);
		}

		public void addEdgeFrom(INode v)
		{
			inn.add(v);
		}

    public IEdge[] getInEdges()
		{
			IEdge[] ret=new IEdge[inn.size()];
			IEdge[] ed=getEdges();
			int jj=0;
			for(int ii=0;ii<ed.length;++ii) // nur die eingehenden Kanten ausgeben
			{
				if(ed[ii].to()==this)
				{
					ret[jj]=ed[ii];
					++jj;
				}
			}
			return ret;
		}

    public IEdge[] getOutEdges()
		{
			IEdge[] ret=new IEdge[outn.size()];
			IEdge[] ed=getEdges();
			int jj=0;
			for(int ii=0;ii<ed.length;++ii)
			{
				if(ed[ii].from()==this)
				{
					ret[jj]=ed[ii];
					++jj;
				}
			}
			return ret;
		}

    public IEdge[] getEdges()
		{
			IEdge[] ret=new IEdge[edges.size()];
			ret=edges.toArray(ret);
			return ret;
		}

    public void removeEdgeTo(INode v)
		{
			outn.remove(v);			
		}

    public void removeEdgeFrom(INode v)
		{
			inn.remove(v);
		}	

    public void removeEdge(IEdge e)
		{
			edges.remove(e);
			if(e.to()!=this) // Auch beim Nachbar loeschen
			{
				e.to().removeEdge(e);
				removeEdgeTo(e.to());
			}
			else
			{
				removeEdgeFrom(e.from());
			}
			
		}

		public void setID(int i) // fuer DFS und andere Graph-Algorithmen
		{
			id=i;
		}

		public int getID()
		{
			return id;
		}
}
