
public class LinHash implements Hash
{

	private int[] A;
	private int a;
	private int m;
	public LinHash(int aa,int mm) // soll als Hash-Funktion h(x)=(ax)mod m verwenden
	{
		A=new int[mm];
		a=aa;
		m=mm;
		for(int ii=0;ii<m;++ii) // initalisieren des Arrays mit "leeren" Werten
		{
			A[ii]=-1;
		}
	}
		
	private	int h(int x)
	{
		return ((a*x)%m);
	}

    public void insert(int k) // Fuegt das Element (hier nicht vorhanden) mit dem Schluessel k in die Hashtabelle ein
		{
			if(k!=-1)
			{
				int hash=h(k); // Hashwert berechnen
				int cnt=hash;
				boolean loop=false;
				while(A[cnt]!=-1) // suche ein freies Feld
				{
					cnt++; // wenn das Feld nicht frei ist muessen wir zum naechsten
					cnt=(cnt%m); // mit Overflow am Ende des Feldes
					if(cnt==hash)
					{
						loop=true; // Das Feld ist voll
						break;
					}
				}
				if(!loop)
				{
					A[cnt]=k; // Einfuegen des Elements, wenn das Feld nicht voll ist.
				}

			
			}
		}

    public void remove(int k) // Entfernt das Element mit dem Schluessel k aus der Hashtabelle
		{
			if(k!=-1)
      {
        int hash=h(k);
        int cnt=hash;
				int move_to;
				boolean loop=false;
				
        while(A[cnt]!=-1) // wir untersuchen, ob das Element vorhanden ist.
        {
          if(A[cnt]==k)
          {
						A[cnt]=-1; // wenn wir das Element gefunden haben (siehe auch find()) dann setzen wir das Feld auf nicht gefuellt zurueck ==> das element mit Schluessel k ist geloesch
						break;
          }
          cnt++;
          cnt=(cnt%m);
          if(cnt==hash)
          {
            return; // wenn das Element mit Schluessel k nicht vorhanden ist, dann brauchen wir auch nichts weiter machen
          }
        }
				move_to=cnt; // beeinhaltet die posistion zu der ein Element u.U. verschoben werden kann
		   cnt++;
       cnt=(cnt%m);
			 if(cnt<move_to)
				{
					loop=true;
				}
			while(A[cnt]!=-1) // wir ueberpruefen nun die nachfolgenden Elemente ob diese weiter "links" stehen muessten
			{
				if( (!loop && h(A[cnt]) <= move_to ) || (loop && h(A[cnt]) <= move_to && cnt < h(A[cnt]) ) )  // wir brauchen zwei unterschiedliche faelle, je nachdem ob ein Overflow statt gefunden hat oder nicht
				{
					A[move_to]=A[cnt]; // wir verschieben das Element an die in move_to gemerkte Position
					A[cnt]=-1; // und Nullen die urspruengliche Position
					move_to=cnt; // und die aktuelle Position an die geschoben wurde ist die Position deren Element gerade verschoben wurde!
				}
				cnt++; // und wir suchen weiter
        cnt=(cnt%m);
				if(cnt<move_to) // Overflow
        {
          loop=true;
        }
			}
			
				


      }
		}

    public boolean find(int k) // Gibt aus, ob das Element mit dem Schluessel k in der Hashtabelle vorhanden ist
		{
			if(k!=-1)
      {
        int hash=h(k); // Hashwert berechnen
        int cnt=hash;
				while(A[cnt]!=-1) // wir brauchen auf Grund der Invariante nur bis zum naechsten nicht benutzten Feld suchen
        {
					if(A[cnt]==k) // wenn wir genau den Schluessel gefunden haben ==> true
					{
						return true; 
					}
          cnt++; // sonst muessen wir weitersuchen
          cnt=(cnt%m); // mit mod
          if(cnt==hash) // und aufhoeren wenn wir einmal jedes Feld abgesucht haben
          {
            break;
          }
        }
				
			}
			return false; // dann muessen wir nicht vorhanden zurueckgeben
		}

}
