
import java.util.*;

public class UIaHeap implements UaHeap
{
		private ArrayList<Integer[]> H;
		private ArrayList<Integer> handle;

		public UIaHeap()
		{ // Init
			H=new ArrayList<Integer[]>();
			handle=new ArrayList<Integer>();
		}
		
		public void build(int[] A) // O(n)
		{
			H=new ArrayList<Integer[]>(); // ganz neu aufbauen
      handle=new ArrayList<Integer>();

			for(int ii=0;ii<A.length;++ii)
			{
				Integer[] el=new Integer[2]; // element
				el[0]=A[ii];      // mit handle verbinden
				el[1]=handle.size();
				H.add(el); // einfuegen
				handle.add(H.size()-1); // handle einfuegen
			}
			for(int ii=H.size();ii>0;--ii)
			{
				siftDown(ii-1); // nach unten schieben, was runter muss
			}
		}
 
		public int min() // O(1)
		{
			if(!H.isEmpty())
			{
				return H.get(0)[0];
			}
			else
			{
				return -1;
			}
		}

		public int deleteMin() // O(logn)
		{
			int ret=-1;
      if(!H.isEmpty())
      {
        ret=H.get(0)[0]; // ausgabe merken
				if(H.size()>1)
				{
					H.set(0,H.remove(H.size()-1)); // letztes element nach vorne
					handle.set(H.get(0)[1],-1); // und das minimum-element loeschen
				}
				else
				{
					handle.set(H.get(0)[1],-1);
					H.remove(H.size()-1);
				}
				if(!H.isEmpty())
				{
					siftDown(0);
				}
      }
			
			return ret;
		}

		public void insert(int e) // O(log n)
		{
			inserth(e);
		} 

		private void siftDown(int ii)
		{
			Integer[] el=H.get(ii);
			int left=2*ii+1;
			int right=2*(ii+1);
			int swp=-1;
			if(right<H.size())
			{
				if(H.get(left)[0] < H.get(right)[0])   //waehle den kleineren Nachbar, weil der evtl. nach oben geschoben wird
				{
					swp=left;
				}
				else
				{
					swp=right;
				}
			}
			else
			{
				if(left<H.size()) 
				{
					swp=left;
				}
				else
				{
					return;
				}
			}
			if(H.get(swp)[0] < H.get(ii)[0]) // muessen wir schieben?
			{
				H.set(ii,H.get(swp));
				handle.set(H.get(ii)[1],ii); // handles anpassen
				H.set(swp,el);
				handle.set(H.get(swp)[1],swp);

				siftDown(swp); //  und rekursiv aufrufen
			}	
		}

		private void siftUp(int ii)
		{
			Integer[] el=H.get(ii);
			int father=(ii-1)/2;
			if(H.get(father)[0]>H.get(ii)[0] && ii>0)  //nur schieben, wenn vater groesser ist
			{
				H.set(ii,H.get(father));
				handle.set(H.get(ii)[1],ii); // swappen und handles setzen
				H.set(father,el);
				handle.set(H.get(father)[1],father);

				siftUp(father); // rekursiv aufrufen
			}
		}

		public int inserth(int e) // O(log n)
		{
			int hand;
			hand=handle.size();
			Integer[] el=new Integer[2];
			el[0]=e;
			el[1]=handle.size();
			H.add(el); // am ende einfuegen
			handle.add(H.size()-1); // handle mekren
			siftUp(H.size()-1); // und nach oben schieben
			return el[1];
		} 

		public void remove(int h) // O(log n)
		{
      Integer[] el=H.get(H.size()-1);
			handle.set(el[1],handle.get(h)); // das zu loeschende Element durch das hinterste Element ersetzen
			handle.set(h,-1);
			
			H.set(handle.get(el[1]),el);
			H.remove(H.size()-1);
			
			siftDown(handle.get(el[1])); // und so weit nach unten schieben ,wie noetig
		}

		public void decreaseKey(int h, int k) // O(log n)
		{
      Integer[] el=H.get(h); // neuen wert setzen
			el[0]=k;
			H.set(h,el);
			siftUp(h); // und nach oben, wenn noetig
		}


}
