
import java.util.*;


public class UIbiHeap implements UHeap
{

private ArrayList<binomialT> lst;
int min;

		public UIbiHeap()
		{
			lst=new ArrayList<binomialT>(); // leere initialisierung
			min=-1;
		}

		public void build(int[] A) //Darf O(nlog n) Zeit brauchen
		{
			for(int ii=0;ii<A.length;++ii) //einfach n mal insert aufrufen
			{
				insert(A[ii]);
			}
		}

    public void insert(int e) // In O(log n)
		{
			binomialT[] ins=new binomialT[1]; // wir bauen einen 
			ins[0]=new binomialTree();
			ins[0].setPrio(e); // einelementigen Heap
			merge(ins);  // und mergen den mit dem bestehenden Heap
		}

    public int min() // In O(1)
		{
			return lst.get(min).getPrio(); // von dem Baum mit dem min-pointer die Prioritaet ausgeben
		}

    public int deleteMin() // in O(log n)
		{
			int ret=min(); // das kleineste Element merken, weil es zurueckgegeben werden muss
			binomialT[] children=lst.get(min).getChildren(); // Alle kinder merken
			lst.set(min,null); // den aktuellen minimum-Baum loeschen
			merge(children);	// und die reste in children mit dem Heap mergen
			return ret;
		}

		private void merge(binomialT[] A)
		{
			binomialT carry=null;
			int ii=0;
			// Ein baum, der im carry steht wird erst im naechst groesseren Platz eingetragen, sprich es gab einen Uebertrag bei der binaeren Addition
			while( ii < A.length || carry!=null) // wir lassen also die Addition laufen, bis wir kein carry mehr haben oder alle Elemente addiert wurden
			{
				if(lst.size()<ii+1) // wenn die aktuelle Liste nicht ausreicht, dann muss sie noch vergroessert werden
				{
					lst.add(null);
				}
				if(carry!=null) // Es steht ein Baum im carry   ======= hier geschieht nur die carry-behandlung =========
				{
					if(lst.get(ii)==null) // wenn kein baum der selben groesse existiert
					{
						lst.set(ii,carry); // schreiben wir das carry an die aktuelle Position
						carry=null;
					}
					else
					{
						carry=carry.merge(lst.get(ii));  // sonst haben wir 2 baeume der selben groesse und mergen diese zu einem baum der naechsten groesse ==> ins carry
						lst.set(ii,null); // die aktuelle position koennen wir dann loeschen
					}
				}
				if( ii < A.length && A[ii]!=null) // an der position steht ein Baum     ======== hier werden Elemente aus A "addiert" ========
				{
					if(lst.get(ii)==null) // wir haben einen Baum in A[ii]
					{
						lst.set(ii,A[ii]);  /// und auch einen Platz dafuer
					}
					else 
					{
						carry=A[ii].merge(lst.get(ii)); // zwei baeume gleichen ranges ==> mergen  ////// man verdeutliche sich, das nie zwei merges in einem While-Koerper-durchlauf auftreten koennen (wir benoetigen also nur einen carry)
						lst.set(ii,null); // und feld leeren
					}
				}
				++ii;
			}
			min=0;
			for(int jj=0;jj<lst.size();++jj) // das neue minimum suchen
			{
				if(lst.get(min)!=null)
				{
					if(lst.get(jj) != null && lst.get(min).getPrio()>lst.get(jj).getPrio())
					{
						min=jj;
					}
				}
				else
				{
					min=jj;
				}
			}
					
		}
				

}
