#ifndef _mirror_repeat_machine_h_
#define _mirror_repeat_machine_h_

#include "hash_map.h"
#include "repeat_machine.h"
#include "stack_fixed_size.h"

namespace papi
{
    /**
     * @class MirrorRepeatMachine
     *
     * Mirror repeat machine
     */
    class MirrorRepeatMachine  : public RepeatMachine
    {
    protected:
        /// Stack for the last k characters in reversed order
        StackFixedSizeRandomAccess<unsigned char> *mirrored_last_k;
    public:
        /**
         * Constructor
         * 
         * @param mirrored_last_k Stack for the last k characters in reversed order
         * @param type_id Type ID of the repeat machine
         * @param word_pos_map Map of all qgram positions
         * @param minimum_region_size Size of the region which is activated around relevant states
         * @param minimum_hit_length Mindest length of an exact repeat that can activate a region
         * @param minimum_relative_probability States with probability lower than this become insignificant
         * @param prob_char Character distribution
         * @param prob_markov Conditional character distribution (markov transition probabilities)
         * @param markov_order Order of the markov model
         */
        MirrorRepeatMachine( StackFixedSizeRandomAccess<unsigned char> *mirrored_last_k, int type_id, unsigned_cstring_fixed_length_list_long_long_hash_map *word_pos_map, long minimum_region_size, long minimum_hit_length,float minimum_relative_probability, float *prob_char,unsigned_cstring_fixed_length_ptr_float_hash_map *prob_markov, int markov_order):
        RepeatMachine( type_id, word_pos_map,minimum_region_size, minimum_hit_length, minimum_relative_probability, prob_char,  prob_markov, markov_order), mirrored_last_k(mirrored_last_k)
        {
            
        }
        /// Overrides RepeatMachine::determineNewRegions
        void determineNewRegions(const unsigned char *buffer,long long pos);
        /// Overrides RepeatMachine::calcNextRowAndUpdateBaseState
        void calcNextRowAndUpdateBaseState(State & baseState, const unsigned char*, long long pos);
        /// Overrides RepeatMachine::updateOldRegions
        void updateOldRegions();
        /// Overrides RepeatMachine::finishRow
        void finishRow(State&);
        /// Overrides RepeatMachine::mergeWithNewStartStates
        void mergeWithNewStartStates(State&,long long pos);
        /// Overrides RepeatMachine::addCompleteRegion
        void addCompleteRegion(long long pos);
        
    } ;

}

#endif

