#ifndef _correlation_h_
#define _correlation_h_


#include <cmath>
#include <fstream>
#include <iostream>
#include <string>

#include "analyze_setting.h"
#include "csv_out_stream.h"
#include "format_helper_out.h"
#include "module.h"
#include "string_utils.h"

namespace papi
{
    ///Modul zum Berechnen der Autokorrelationsfunktion eines DAR(p) und Transinformationsfunktion
    /**
     * @class Correlation
     * 
     * Module to calculate mutual information function, autocorrelation parameters
     * of a dar process and character distribution.
     */
    class Correlation : public Module
    {
    protected:
        
        /// module name
        std::string module_id;
        
        /// distance between two points at which the mutual information function is calculated
        int mutual_information_step;
        /// start point at which to calculate the mutual information function
        int mutual_information_max;
        /// maximal point at which to calculate the mutual information function
        int mutual_information_min;
        
        /// Smallest point >= autocorrelation_dar_max at which the mutual information function is evaluated.
        int mutual_information_min_rest;
        
        /// Order of the dar proces
        int autocorrelation_dar_max;
        
        /// size of the alphabet
        int size_alphabet;
        
        /// disable autocorrelation output
        bool disable_ac;
        
        /// disable mutual information output
        bool disable_mi;
        
        /// disable character distribution output
        bool disable_character_distribution;

        /// character counts
        long long *count_char;

        /// Counts character pairs with distance k
        /**
         * The first two indices are the characters, the third index is the distance
         * The elements count_dist_k[a][b][0,..,autocorrelation_dar_max-1] contain 
         * the counters for distances 1 to autocorrelation_dar_max.
         * The rest contains the distances from mutual_information_min_rest to 
         * mutual_information_max in steps of mutual_information_step
         */
        long long ***count_dist_k;
        
        /// character distribution
        long double *prob;
        
        /// Index map
        const IndexMap<char> *ind_map;
        
        /// mutual information function
        long double *mutual_information;
        
        /// autocorrelation parameters
        long double *autocorrelation_dar;

    public:
        /**
         * Constructor
         *
         * @param[in] name Module name
         */
        Correlation( char const* name);
        /**
         * Destructor
         */
        ~Correlation();
        /// Overrides Module::init
        void init(AnalyzeSetting & settings, long long file_length,const  IndexMap<char> *ind_map);
        /// Overrides Module::process
        void process(long long bufSize,unsigned char const* buffer,std::string directory, bool write_stdout, long file_id,std::string file_path,long long file_length);
        /// Overrides Module::getId
        const std::string getId();
        
    };
        
    
}

#endif

