#ifndef _entropy_h_
#define _entropy_h_


#include <cmath>
#include <fstream>
#include <iostream>
#include <locale>
#include <sstream>
#include <string>

#include "analyze_setting.h"
#include "csv_out_stream.h"
#include "format_helper_out.h"
#include "hash_map.h"
#include "module.h"
#include "string_utils.h"

namespace papi
{

    /**
     * @class Entropy
     *
     * Module to estimate block entropy, conditional entropy and to 
     * calculate qgram and character distribution.
     */
    class Entropy : public Module
    {
    protected:
        /// module name
        std::string module_id;
        
        /// actual length of qgrams which are counted (maximum of entrop_entries and qgram_length_setting)
        int qgram_length_actual;
        
        /// number of values to calculate for block entropy and conditional entropy
        int entropy_entries;
        
        /// qgram length as defined in the settings file
        int qgram_length_setting;
        
        /// size of the alphabet
        int size_alphabet;
        
        /// disable entropy output
        bool disable_entropy;
        /// disable qgram distribution output
        bool disable_qgram_distribution;
        /// disable character distribution output
        bool disable_character_distribution;
                
        /// character counts
        int *count_char;

        /// qgram counts
        unsigned_cstring_fixed_length_long_long_hash_map *count_word;
        
        /// character distribution
        long double *prob;
        
        /// Index map
        const IndexMap<char> *ind_map;
        
        /// blocke entropy with correction term according to Miller
        long double *block_entropy;
        
        
        /**
         * Because of consistency reasons conditional entropy does NOT use
         * Millers correction term. Therefore conditional entropy is not exactly
         * the difference of the block entropies.
         */
        long double *cond_entropy;
        
        /**
         * Concatenation of the last and the first word in order to get 
         * a qgram distribution which result in an irreducible markov chain
         */
        unsigned char *tail;

        
    public:
        /**
         * Constructor
         *
         * @param[in] name Module name
         */
        Entropy( char const* name);
        
        /**
         * Destructor
         */
        ~Entropy();
        /// Overrides Module::init
        void init(AnalyzeSetting & settings, long long file_length,const  IndexMap<char> *ind_map);
        /// Overrides Module::process
        void process(long long bufSize,unsigned char const* buffer,std::string directory, bool write_stdout, long file_id,std::string file_path,long long file_length);
        /// Overrides Module::getId
        const std::string getId();
        
    };
}

#endif

