#ifndef _frequency_distribution_h_
#define _frequency_distribution_h_

#include <cctype>
#include <climits>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <map>
#include <set>
#include <string>

#include <boost/regex.hpp>

#include "analyze_setting.h"
#include "csv_out_stream.h"
#include "format_helper_out.h"
#include "hash_map.h"
#include "index_map.h"
#include "module.h"
#include "string_utils.h"

namespace papi
{

    /**
     * @class FrequencyDistribution
     *
     * Module to calculate character distribution, bigram distribution and word distribution
     */
    class FrequencyDistribution : public Module
    {
    protected:
        /// module name
        std::string module_id;
        /// character counts
        long long *count_character;
        // bigram counts
        long long **count_bigram;
        /// Index map
        const IndexMap<char> *ind_map;
        /// word counts
        pair_unsigned_cstring_int_long_long_hash_map count_word;
        /// Total number of words
        long long count_word_sum;
        /// Position of the beginning of the current word
        long long last_word_begin;
        /// delimiters
        bool word_delimiters[CHAR_ANZ];
        /// size of the alphabet
        int size_alphabet;
        
        /// disable word distribution submodule
        bool disable_word_distribution;
        /// disable character distribution submodule
        bool disable_character_distribution;
        /// disable bigram distribution submodule
        bool disable_bigram_distribution;
        
        /// true, if searching for the beginning of the next word
        bool search_next_word;

        
    public:
        /**
         * Constructor
         *
         * @param[in] name module name
         */
        FrequencyDistribution( char const* name);
        /**
         * Destructor
         */
        ~FrequencyDistribution();
        /// Overrides Module::init
        void init(AnalyzeSetting & settings, long long file_length,const  IndexMap<char> *ind_map);
        /// Overrides Module::process
        void process(long long bufSize,unsigned char const* buffer,std::string directory, bool write_stdout, long file_id,std::string file_path,long long file_length);
        /// Overrides Module::getId
        const std::string getId();
    };

}

#endif

