#ifndef _Dar_h_
#define _Dar_h_

#include <cmath>
#include <fstream>
#include <iostream>
#include <string>

#include "format_helper_in.h"
#include "generator.h"
#include "index_map.h"
#include "linear_equation.h"
#include "queue_fixed_size.h"
#include "random.h"

using namespace std;

namespace papi
{
    /**
     * @class Dar
     * Generator for a discrete autoregressive process.
     */
    class Dar: public Generator
    {
    public:
        /// Overrides Generator::generate
        void generate( long long length,  map<string,string> &parameters);
        
        /// Constructor
        Dar();
        
        /// Destructor
        ~Dar();
        
    protected:
        
        /// Probability for copy operation
        double rho;
        /// Probability distribution for relative position for copy operation
        double *alpha_prob;
        /// Order of the DAR(p) process
        int order;
        /// Character distribution
        double *character_prob;
        /// Index map of alphabet
        IndexMap<char> ind;
        /// Queue storing the last k characters
        QueueFixedSizeRandomAccess<int> *last_k;
        /// Weighted die
        Die die;
        
        /**
         * Generate next character
         * @return Next generated character
         */
        int generateCharacter();
        
        ///Berechne DAR-Prozessparameter aus der Autokorrelationsfunktion und Zeichenwahrscheinlichkeit
        /**
         * Calculate alpha_prob using given autocorrelation parameters
         * @param[in] autocorrelation Autocorrelation parameters
         */
        void estimateParameters( long double *autocorrelation);
        
        /**
         * Initialize DAR(p) process from parameter files
         * @param[in] file_autocorrelation Path to autocorrelation parameter file or NULL if stdin
         * @param[in] file_prob Path to character distribution parameter file or NULL if stdin
         */
        void init(const char *file_autocorrelation, const char *file_prob);
        
        /**
         * Generate sequence.
         * @param[in] length Length of the sequence to be generated
         */
        void generateSequence(long long length);
    };

}

#endif

