#ifndef _fibonacci_h_
#define _fibonacci_h_

#include <iostream>
#include <stdlib.h>
#include <string>

#include <boost/dynamic_bitset.hpp>


#include "generator.h"


using namespace std;

namespace papi {
    /**
     * @class Fibonacci 
     * Fibonacci word generator
     */
    class Fibonacci : public Generator{
    public:
        /// Overrides Generator::generate
        void generate(long long length,  map<string,string> &parameters);
        
        /**
         * Constructor
         * @param[in] a First character of alphabet
         * @param[in] b Second character of alphabet
         * @param[in] use_tmp_file True, if a temp file should be used insted of a buffer in the memory
         */
        Fibonacci(char a, char b, bool use_tmp_file);
        /**
         * Constructor using standard alphabet ab
         * @param[in] use_tmp_file True, if a temp file should be used insted of a buffer in the memory
         */
        Fibonacci(bool use_tmp_file);
        /**
         * Constructor using buffer in memory
         * @param[in] a First character of alphabet
         * @param[in] b Second character of alphabet
         */
        Fibonacci(char a, char b);
        /**
         * Constructor using standard alphabet ab and buffer in memory
         */
        Fibonacci();
    protected:
        /// First character of the alphabet
        char a;
        /// Second character of the alphabet
        char b;
        /// True if a temp file instead of a buffer in the main memory should be used.
        bool use_tmp_file;
    };
}

#endif
