#ifndef _generator_h_
#define _generator_h_

#include <iostream>
#include <fstream>
#include <map>
#include <string>

using namespace std;

namespace papi
{
    /**
     * @class Generator
     * Abstract base class for all generators
     */
    class Generator
    {
    protected:
        /// Output file
        ofstream oFile;
        /// True, if print to stdout
        bool write_stdout;
        /// Path to output file
        const char *output_file;
    public:
        /**
         * Generate a text of certain length.
         * @param[in] length Length of the sequence to be generated
         * @param[in] parameters Map from parameter types to parameter files
         */
        virtual void generate(long long length,  map<string,string> &parameters) = 0;

        /**
         * Initialize generator and output file.
         * @param[in] output_file Path to output file
         * @param[in] write_stdout True, if print to stdout
         */
        void initOutput(const char *output_file, bool write_stdout);

        /**
         * Write output
         * @param[in] a What to write
         */
        template <class T>
        void write(T a) {
            if(oFile.is_open()) {
                oFile << a;
            }
            if(write_stdout) {
                cout << a;
            }
        }
        
        /**
         * Write char buffer.
         * @param[in] buffer The buffer
         * @param[in] length Length of the buffer
         */
        void write(char buffer[], long long length);
        
        /**
         * Destructor.
         */
        virtual ~Generator(){
            if(oFile.is_open()) {
                oFile.close();
            }
        }
    };

}

#endif

