#include "csv_in_stream.h"

using namespace std;

namespace papi {
    
    int CsvInStream::getNextInt() {
        return atoi(getNextCell().c_str());
    }
    
    double CsvInStream::getNextDouble() {
        return atof(getNextCell().c_str());
    }
    
    void CsvInStream::skipLine(){
        int c;
        while(stream->good() && ((c=stream->get())!='\n') );
    }
    
    string CsvInStream::getNextCell() {
        bool isQuoted = false;
        char c = 0;
        string s,t;
        
        while(good() && (isQuoted || (c!=';' && c!='\n'))) {
            (*stream) >> c;
            if(!good()) {
                return s;
            }
            if(isQuoted) {
                switch(c) {
                    case '"':
                        (*stream) >> c;
                        if(!good()) {
                            return s;
                        }
                        // EXCEL compatibility: escape quote character with two quote characters
                        if(c=='"') {
                            s.push_back('"');
                        } else {
                            isQuoted = false;
                            stream->unget();
                            c = 0;
                        }
                        break;
                    case '\\': 
                        (*stream) >> c;
                        if(!good()) {
                            s.push_back('\\');
                            return s;
                        }
                        switch (c) {
                            case '\\': s.push_back('\\');break;
                            case 't': s.push_back('\t');break;
                            case 'n': s.push_back('\n');break;
                            case 'v': s.push_back('\v');break;
                            case 'f': s.push_back('\f');break;
                            case 'r': s.push_back('\r');break;
                            case '"': s.push_back('"');break;
                            case 'x': 
                                (*stream)>>c;
                                if(!good()) {
                                    s.push_back('u');
                                    return s;
                                }
                                t.push_back(c);
                                (*stream)>>c;
                                if(!good()) {
                                    return s + 'u' + t;
                                }
                                t.push_back(c);
                                s.push_back(hex2char(t));
                                break;
                            default:
                                cerr << "ERROR while reading csv file: unknown escape sequence: " << '\\' << c << endl;
                                exit(EXIT_FAILURE);
                        }
                        break;
                    default:
                        s.push_back(c);
                }
            } else if(c=='"') {
                isQuoted = true;
            } else if(c!=';' && c!='\n'){                
                s.push_back(c);
            }
        }
        return s;
    }
    
    bool CsvInStream::good() {
        return stream->good();
    }
}
