#ifndef _csv_in_stream_h_
#define _csv_in_stream_h_

#include <iostream>
#include <string>

#include "format_helper_out.h"

using namespace std;

namespace papi {
    
    /**
     * @class CsvInStream
     * Class to conveniently read values from a csv formatted stream.
     */
    class CsvInStream {
    protected:
        /// Input stream
        istream *stream;
    public:
        /**
         * Constructor
         * @param[in] s Pointer to input stream
         */
        CsvInStream(istream *s): stream(s) {
            (*s) >> noskipws;
        }
        
        /**
         * Extract next cell as an integer.
         * @return The value of the next cell as an integer
         */
        int getNextInt();
        /**
         * Extract next cell as a double.
         * @return The value of the next cell as a double
         */
        double getNextDouble();
        /**
         * Extract next cell.
         * @return The value of the next cell.
         */
        string getNextCell();
        /**
         * True, if the stream is still good. Calls stream->good()
         * @return True, if the stream is still good.
         */
        bool good();
        /**
         * Skip the current line.
         */
        void skipLine();
    };
}

#endif
