//
//  format_helper_out.cpp
//  tt-analyze
//
//  Created by Andre Dau on 17/03/11.
//  Copyright 2011 TU Muenchen. All rights reserved.
//

#include "format_helper_out.h"

using namespace std;

namespace papi {
    
    void initCsvOut(CsvOutStream &csv, ofstream &oFile, 
                    string &dir, bool write_stdout, 
                    const string &prefix, const char *name) {
        if(!dir.empty()) {
            string filename = dir + "/" + prefix + "_" + name + ".csv";
            oFile.open(filename.c_str(), ios::trunc);
            if(oFile.is_open()) {
                csv.addStream(&oFile);
            } else {
                cerr<<"ERROR: Cant write result file "<<filename<<endl;
            }
        }
        if(write_stdout) {
            csv.addStream(&cout);
        }        
    }
    
    void printCsvHeader(CsvOutStream &csv, long file_id, string file_path, 
                        long long file_length, string type_identifier)
    {
        csv.addCell("file_id");
        csv.addCell(file_id);
        csv.newline();
        csv.addCell("file_path");
        csv.addCell(file_path);
        csv.newline();
        csv.addCell("file_length");
        csv.addCell(file_length);
        csv.newline();
        csv.addCell("content_type");
        csv.addCell(type_identifier);
        csv.newline();
    }
    
    void printCsvQgramDistributionHeader(CsvOutStream &csv, ofstream &oFile,
                                         string &dir, bool write_stdout, const string &prefix, 
                                         long file_id, string &file_path, long long file_length,
                                         int qgram_length, int alphabet_size ){
        initCsvOut(csv, oFile, dir, write_stdout, prefix, "qgram_distribution");
        printCsvHeader(csv,file_id, file_path, file_length,"qgram_distribution");
        csv.addCell("qgram_length");
        csv.addCell(qgram_length);
        csv.newline();
        csv.addCell("alphabet_size");
        csv.addCell(alphabet_size);
        csv.newline();
        csv.addCell("qgram");
        csv.addCell("relative frequency density");
        csv.newline();
        
    }
    
    void printCsvAutocorrelationDar(string &dir, bool write_stdout, const string &prefix, 
                                    long file_id, string &file_path, long long file_length,
                                    long double *autocorrelation_dar, int autocorrelation_dar_max) {
        CsvOutStream csv(POINT);
        ofstream oFile;

        initCsvOut(csv, oFile, dir, write_stdout, prefix, "autocorrelation_dar");
        
        printCsvHeader(csv,file_id, file_path, file_length,"autocorrelation_dar");
        csv.addCell("number_entries");
        csv.addCell(autocorrelation_dar_max+1);
        csv.newline();
        csv.addCell("k");
        csv.addCell("r(k)");
        csv.newline();
        for(int i=0;i<=autocorrelation_dar_max;++i)
        {
            csv.addCell(i);
            csv.addCell(autocorrelation_dar[i]);
            csv.newline();
        }    
        if(oFile.is_open()) {
            oFile.close();
        }
    }
     
    void printCsvMutualInformation(string &dir, bool write_stdout, const string &prefix, 
                                   long file_id, string &file_path, long long file_length,
                                   long double *mutual_information, int mutual_information_min, 
                                   int mutual_information_max, int mutual_information_step){
        
        CsvOutStream csv(POINT);
        ofstream oFile;
        initCsvOut(csv, oFile, dir, write_stdout, prefix, "mutual_information");
                
        int mutual_information_num = (mutual_information_max-mutual_information_min)/mutual_information_step+1;

        printCsvHeader(csv,file_id, file_path, file_length,"mutual_information");
        csv.addCell("number_entries");
        csv.addCell(mutual_information_num);
        csv.newline();
        csv.addCell("k");
        csv.addCell("I(k)");
        csv.newline();           
        for(int mutual_information_index = 0,k_output = mutual_information_min;k_output<=mutual_information_max; ++mutual_information_index,k_output+=mutual_information_step)
        {
            csv.addCell(k_output);
            csv.addCell(mutual_information[mutual_information_index]);
            csv.newline();
        }
        
        if(oFile.is_open()) {
            oFile.close();
        }
    }
    
    void printCsvEntropy(string &dir, bool write_stdout, const string &prefix, 
                         long file_id, string &file_path, long long file_length,
                         long double *block_entropy, long double *cond_entropy,
                         int entropy_entries) {
        CsvOutStream csv(POINT);
        ofstream oFile;
        initCsvOut(csv, oFile, dir, write_stdout, prefix, "entropy");
        printCsvHeader(csv,file_id, file_path, file_length,"entropy");
        csv.addCell("entropy_entries");
        csv.addCell(entropy_entries);
        csv.newline();
        csv.addCell("block_entropy");
        csv.newline();
        csv.addCell("n");
        csv.addCell("H(X_1,...,X_n)");
        csv.newline();
        for(int i=0;i<entropy_entries;++i)
        {
            csv.addCell(i+1);
            csv.addCell(block_entropy[i]);
            csv.newline();
        }
        
        csv.addCell("conditional_entropy");
        csv.newline();
        csv.addCell("n");
        csv.addCell("H(X_n | X_1,...,X_{n-1})");
        csv.newline();
        for(int i=0;i<entropy_entries;++i)
        {
            csv.addCell(i);
            csv.addCell(cond_entropy[i]);
            csv.newline();
        }
        if(oFile.is_open()) {
            oFile.close();
        }

    }
    
    void printCsvWordDistribution(string &dir, bool write_stdout, const string &prefix, 
                                  long file_id, string &file_path, long long file_length,
                                  const IndexMap<char> *ind_map, bool *word_delimiters,
                                  pair_unsigned_cstring_int_long_long_hash_map &count_word,
                                  long long count_word_sum) {
        CsvOutStream csv(POINT);
        ofstream oFile;
        
        initCsvOut(csv, oFile, dir, write_stdout, prefix, "word_distribution");
        
        printCsvHeader(csv,file_id, file_path, file_length,"word_distribution");
        int num_delimiters = 0;
        for(int i=0;i<ind_map->size;++i) {
            if(word_delimiters[i]) {
                ++num_delimiters;
            }
        }
        csv.addCell("delimiters");
        csv.addCell(num_delimiters);
        csv.newline();
        for(int i=0;i<ind_map->size;++i) {
            if(word_delimiters[i]) {
                csv.addCell(ind_map->getValue(i));
                csv.newline();
            }
        }
        csv.addCell("number_words");
        csv.addCell(count_word_sum);
        csv.newline();
        csv.addCell("word");
        csv.addCell("relative frequency density");
        csv.newline();
        for(pair_unsigned_cstring_int_long_long_hash_map::iterator it = count_word.begin(); it!= count_word.end(); ++it)
        {
            if((*it).second>0)
            {
                string s;
                for(int i=0;i<it->first.second;++i)
                    s.push_back(ind_map->getValue((*it).first.first[i]));
                csv.addCell(s);
                csv.addCell((*it).second/(double)(count_word_sum));
                csv.newline();
            }
        }
        if(oFile.is_open()) {
            oFile.close();
        }

    }
    
    void printCsvBigramDistribution(string &dir, bool write_stdout, const string &prefix, 
                                    long file_id, string &file_path, long long file_length,
                                    const IndexMap<char> *ind_map, long long **count_bigram,
                                    long long num_distinct_bigrams, long long all_bigrams) {
        CsvOutStream csv(POINT);
        ofstream oFile;
        initCsvOut(csv, oFile, dir, write_stdout, prefix, "bigram_distribution");
        printCsvHeader(csv,file_id, file_path, file_length,"bigram_distribution");
        csv.addCell("number_bigrams");
        csv.addCell(num_distinct_bigrams);
        csv.newline();
        csv.addCell("bigram");
        csv.addCell("relative frequency density");
        csv.newline();
        for(int i=0; i<ind_map->size; ++i)
        {
            for(int j=0;j<ind_map->size; ++j)
            {
                string s;
                s.push_back(ind_map->getValue(i));
                s.push_back(ind_map->getValue(j));
                if(count_bigram[i][j]>0 && all_bigrams>0)
                {
                    csv.addCell(s);
                    csv.addCell(count_bigram[i][j]/(long double)(all_bigrams));
                    csv.newline();
                }
            }
        }
    }
    
    void printCsvRepeats(string &dir, bool write_stdout, const string &prefix, 
                         long file_id, string &file_path, long long file_length,
                         const char *machine_name, const char **params, 
                         float *distribution, int num_params,
                         const IndexMap<char> *ind_map, unsigned char* complement) {
        CsvOutStream csv(POINT);
        ofstream oFile;
        
        initCsvOut(csv, oFile, dir, write_stdout, prefix, machine_name);
        printCsvHeader(csv,file_id, file_path, file_length,machine_name);
        if(ind_map && complement) {
            csv.addCell("alphabet_size");
            csv.addCell(ind_map->size);
            csv.newline();
            csv.addCell("inverted_alphabet");
            csv.newline();
            for(int i=0;i<ind_map->size;++i) {
                csv.addCell(ind_map->getValue(i));
                csv.addCell(ind_map->getValue(complement[i]));
                csv.newline();
            }
        }
        csv.addCell("transition_probabilities");
        csv.addCell(num_params);
        csv.newline();
        for(int i=0; i< num_params;++i)
        {
            csv.addCell(params[i]);
            csv.addCell(distribution[i]);
            csv.newline();
        }
    }
    
    void printCsvRepeatsIterationsHeader(CsvOutStream &csv,ofstream &oFile,
                                         string &dir, bool write_stdout, const string &prefix, 
                                         long file_id, string &file_path, long long file_length,
                                         const char *machine_name, const char **params,
                                         int num_params){
        string name = "iterations_";
        name += machine_name;
        initCsvOut(csv, oFile, dir, write_stdout, prefix, name.c_str());
        printCsvHeader(csv,file_id, file_path, file_length, name.c_str());
        csv.addCell("Iteration");
        for(int i=0; i< num_params;++i)
            csv.addCell(params[i]);
        csv.newline();
    }
    void printCsvRepeatsIteration(CsvOutStream &csv, float *distribution, int num_params, int iteration) {
        csv.addCell(iteration);
        for(int i=0;i<num_params;++i)
            csv.addCell(distribution[i]);
        csv.newline();        
    }


}
