#ifndef _linear_equation_h_
#define _linear_equation_h_


#include <boost/numeric/ublas/lu.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>

namespace papi {
    /**
     * Solves a linear equation of the form Ax = b
     *
     * @param[in] A the coefficient matrix
     * @param[in,out] b Before: The vector of constant term; After: The solution
     */
    void solveLinearEquation(boost::numeric::ublas::matrix<double> &A, boost::numeric::ublas::vector<double> &b);
}


#endif

