#ifndef _matrix_h_
#define _matrix_h_

#include <cmath>
#include <iostream>

namespace papi
{

    /**
     * @class NDimMat
     * Matrix of fixed dimension
     */
    template <class T>
    class NDimMat 
    {
    protected:
        /// Used if alphabet size is known; array containing values
        T *mat;
        /// Maximal size of the alphabet
        int size_alphabet;
        /// Value with which matrix elements are initialized
        int init_val;
        /// Dimension of the matrix
        int dim;
    public:
        /**
         * Constructor
         * @param dim Dimension of the matrix
         * @param size_alphabet Size of the alphabet
         * @param init_val Value with which to initialize the fields
         */
        NDimMat(int dim, int size_alphabet,int init_val):
        mat(NULL), size_alphabet(size_alphabet), init_val(init_val), dim(dim)
        {
            int size = (int)pow((double)size_alphabet,(double)dim);
            mat = new T[size];
            memset(mat,init_val,size*sizeof(T));
        }
        
        /**
         * Destructor
         */
        ~NDimMat()
        {
            if(mat)
                delete [] mat;
        }
        
        /**
         * Access the matrix with an index vector
         * @param[in] index_vector The index vector of size dim
         * @return Value of the element at the requested position
         */
        T& get(int *index_vector)
        {
            int index = index_vector[0];
            if(index_vector[0]>=size_alphabet || index_vector[0]<0)
            {
                std::cerr<< "NDimMat: Index out of bound"<<std::endl<<"Index: ";
                for(int j=0; j<dim;++j)
                    std::cerr<<index_vector[j]<<" ";
                std::cerr<<std::endl;
                exit(EXIT_FAILURE);
            }
            for(int i=1; i<dim;++i)
            {
                if(index_vector[i]>=size_alphabet || index_vector[i]<0)
                {
                    std::cerr<< "NDimMat: Index out of bound"<<std::endl<<"Index: ";
                    for(int j=0; j<dim;++j)
                        std::cerr<<index_vector[j]<<" ";
                    std::cerr<<std::endl;
                    exit(EXIT_FAILURE);
                }
                index = index*size_alphabet + index_vector[i];
            }
            return mat[index];
        }
    };


}

#endif

