#include "direct_repeat_machine.h"

namespace papi
{

    void DirectRepeatMachine::updateOldRegions()
    {
        updateOldRegionsDir(FORWARD);
    }


    void DirectRepeatMachine::finishRow(State & baseState)
    {
        finishRowDir(baseState,FORWARD);
    }


    void DirectRepeatMachine::mergeWithNewStartStates(State & baseState, long long pos)
    {
        mergeWithNewStartStatesDir(baseState,pos,FORWARD);
    }

    void DirectRepeatMachine::determineNewRegions(const unsigned char *buffer,long long pos)
    {
        unsigned_cstring_fixed_length_list_long_long_hash_map::const_iterator it = word_pos_map->find(buffer+pos);
        
        if(it!=word_pos_map->end())
        {
            
            for(list<long long>::const_iterator it2 = it->second.begin();it2!=it->second.end() && *it2<(long long)pos;++it2)
            {
                
                long long start = max(0ll,(*it2)-minimum_region_size);
                long long end = min((long long)pos,(*it2)+minimum_region_size+1l);
                new_hit_regions.push_back(Region(start,end,0));
            }
        }
    }


    void DirectRepeatMachine::calcNextRowAndUpdateBaseState(State & baseState, const unsigned char * buffer, long long pos)
    {
        
        //v_state neighbouring state (vertical)
        //d_state neighbouring state (diagonal)
        State v_state, d_state;
        list<State>::iterator it_state = states.begin();
        for(list<Region>::iterator it_region = active_regions->begin(); it_region!=active_regions->end();++it_region)
        {
            v_state.reset();
            d_state.reset();
            
            
            long long start = it_region->start;
            long long end = it_region->end;
            
            // Follow transitions  (NOTE: delete transitions were already processed in #finishRow
            for( long long i =start; i<end-1;++i,++it_state)
            {
                //insert transition
                v_state.merge(*it_state,prob[INDEL]*getProbCharNormalized(buffer,pos,-1),INDEL,type_id);
                
                //Match or Change
                if(buffer[pos] == buffer[i])
                    d_state.merge(*it_state,prob[MATCH],MATCH,type_id);
                else
                    d_state.merge(*it_state,prob[CHANGE]*getProbCharNormalized(buffer,pos,buffer[i]),CHANGE,type_id);
                
                // finish vertical state
                swap(v_state,*it_state);
                
                // shift to the right -> diagonal becomes vertical state
                swap(d_state,v_state);
                d_state.reset();
            }
            
            // Normalize match,change insert
            v_state.merge(*it_state);
            v_state.prob*=prob[INDEL]*getProbCharNormalized(buffer,pos,-1)/(1-prob[INDEL]);
            if(buffer[pos] == buffer[end-1])
            {
                d_state.merge(*it_state);
                d_state.prob*=prob[MATCH]/(1-prob[INDEL]);
            }
            else
            {
                d_state.merge(*it_state);
                d_state.prob*=prob[CHANGE]*getProbCharNormalized(buffer,pos,buffer[end-1])/(1-prob[INDEL]);
            }
            swap(v_state,*it_state);
            swap(d_state,v_state);
            ++it_state;
            
            
            *it_state = v_state;
            ++it_state;
        }
        
        
    }


    void DirectRepeatMachine::addCompleteRegion(long long pos)
    {
        addCompleteRegionDir(pos,FORWARD);
    }

}

