#include "inverted_repeat_machine.h"

namespace papi
{

    void InvertedRepeatMachine::updateOldRegions()
    {
        updateOldRegionsDir(BACKWARD);
    }


    void InvertedRepeatMachine::finishRow(State & baseState)
    {
        finishRowDir(baseState,BACKWARD);
        
    }
    void InvertedRepeatMachine::mergeWithNewStartStates(State & baseState, long long pos)
    {
        mergeWithNewStartStatesDir(baseState,pos,BACKWARD);
    }


    void InvertedRepeatMachine::determineNewRegions(const unsigned char *buffer,long long pos)
    {
        unsigned_cstring_fixed_length_list_long_long_hash_map::const_iterator it = word_pos_map->find(inverted_last_k->start);
        
        if(it!=word_pos_map->end())
        {
            
            for(list<long long>::const_iterator it2 = it->second.begin();it2!=it->second.end() && *it2<=(long long)pos-minimum_hit_length;++it2)
            {
                long long hit_pos = *it2+minimum_hit_length-1ll;
                long long start = max(-1ll,hit_pos-minimum_region_size-1ll);
                long long end = min((long long)pos-1ll,hit_pos+minimum_region_size);
                new_hit_regions.push_back(Region(start,end,0));
            }
            
        }
    }

    void InvertedRepeatMachine::calcNextRowAndUpdateBaseState(State & baseState, const unsigned char * buffer, long long pos)
    {
        //v_state neighbouring state (vertical)
        //d_state neighbouring state (diagonal)
        State v_state, d_state;

        list<State>::reverse_iterator it_state = list<State>::reverse_iterator (unused_states);
        for(list<Region>::reverse_iterator it_region = active_regions->rbegin(); it_region!=active_regions->rend();++it_region)
        {
            v_state.reset();
            d_state.reset();
            
            
            long long start = it_region->start;
            long long end = it_region->end;
            
            // Follow transitions  (NOTE: delete transitions were already processed in #finishRow
            for( long long i =end; i>start+1;--i,++it_state)
            {
                //Insert transition
                v_state.merge(*it_state,prob[INDEL]*getProbCharNormalized(buffer,pos,-1),INDEL,type_id);
                
                //Match or Change
                if(buffer[pos] == complement[buffer[i]])
                    d_state.merge(*it_state,prob[MATCH],MATCH,type_id);
                else
                    d_state.merge(*it_state,prob[CHANGE]*getProbCharNormalized(buffer,pos,complement[buffer[i]]),CHANGE,type_id);
                
                // finish vertical state
                swap(v_state,*it_state);
                // shift to the left -> diagonal becomes vertical state
                swap(d_state,v_state);
                d_state.reset();
            }
            // Normalize match,change insert
            v_state.merge(*it_state);
            v_state.prob*=prob[INDEL]*getProbCharNormalized(buffer,pos,-1)/(1-prob[INDEL]);
            if(buffer[pos] == complement[buffer[start+1]])
            {
                d_state.merge(*it_state);
                d_state.prob*=prob[MATCH]/(1-prob[INDEL]);
            }
            else
            {
                d_state.merge(*it_state);
                d_state.prob*=prob[CHANGE]*getProbCharNormalized(buffer,pos,complement[buffer[start+1]])/(1-prob[INDEL]);
            }
            swap(v_state,*it_state);
            swap(d_state,v_state);
            ++it_state;
            *it_state = v_state;
            ++it_state;
        }    
    }

    void InvertedRepeatMachine::addCompleteRegion(long long pos)
    {
        addCompleteRegionDir(pos,BACKWARD);
    }

}

