
#include "fibonacci.h"

using namespace std;

namespace papi {
    Fibonacci::Fibonacci (char a, char b, bool use_tmp_file):
        a(a), b(b), use_tmp_file(use_tmp_file){
    }
    Fibonacci::Fibonacci (char a, char b):
        a(a), b(b), use_tmp_file(false) {
    }
    
    Fibonacci::Fibonacci (bool use_tmp_file):
        a('a'), b('b'), use_tmp_file(use_tmp_file){
    }
    Fibonacci::Fibonacci ():
        a('a'), b('b'), use_tmp_file(false){
    }
    
    void Fibonacci::generate(long long length, map<string, string> &parameters) {
        long long l = 0;
        long long l_old;
        ifstream iFile;
        char tmp_file_name[28] = "_tmp_tt_generate_fibonacci_";
        boost::dynamic_bitset<> *buffer = NULL;
        bool tmp_file_created = false;
        
        if(length >  2) {
            if(use_tmp_file) {
                if(oFile.is_open()) {
                    iFile.open(output_file);
                } else {
                    oFile.open(tmp_file_name);
                    iFile.open(tmp_file_name);
                    tmp_file_created = true;
                }            
            } else {
                buffer = new boost::dynamic_bitset<>(length,2ul);
            }
        }

        if(length == 0) {
            return;
        }
        
        //S_0
        write(a);
        ++l;
        
        //S_1
        if(length == 1) {
            return;
        }
        write(b);
        ++l;
        
        //length of S_0
        l_old = 1;
        
        while ( l < length ) {
            long long i = 0;
            if(use_tmp_file) {
                oFile.flush();
                iFile.seekg(0, ios_base::beg);
            }
            //next fibonacci word
            long long tmp = l;
            while( l < length && i < l_old) {
                if(use_tmp_file) {
                    char c;
                    iFile >> c;
                    write(c);
                } else {
                    if((*buffer)[i] == 0) {
                        write(a);
                        (*buffer)[l] = 0;
                    } else {
                        write(b);
                        (*buffer)[l] = 1;
                    }
                }
                ++i;
                ++l;
            }
            l_old = tmp;
        }
        if(iFile.is_open()) {
            iFile.close();
        }
        if(oFile.is_open()) {
            oFile.close();
        }
        if(tmp_file_created) {
            remove(tmp_file_name);
        }

    }
    
    
}
