
#include "generator.h"

using namespace std;

namespace papi {
    void Generator::initOutput(const char *output_file, bool write_stdout) {
        if(output_file != NULL) {
            oFile.open(output_file);
            if(!oFile.is_open()) {
                cerr << "Could not open output file " << output_file << endl;
            }
        }
        this->output_file = output_file;
        this->write_stdout = write_stdout;
    }
    
    void Generator::write(char buffer[], long long length) {
        if(oFile.is_open()) {
            oFile.write(buffer, length);
        }
        if(write_stdout) {
            cout.write(buffer, length);
        }
    }
}
