
#include "markov.h"

using namespace std;

namespace papi
{

    Markov::Markov():
    character_prob_rand_interval(NULL),ind(CHAR_MIN,CHAR_MAX), last_k(NULL), 
    conditional_probability(NULL), uniform(false)
    {}

    Markov::~Markov()
    {
        if(character_prob_rand_interval)
            delete [] character_prob_rand_interval;
        if(last_k)
            delete last_k;
        if(conditional_probability) {
            delete conditional_probability;
        }
    }
    
    
    void Markov::init(const char *file_character_prob,const char *file_cond_prob)
    {
        ParameterParser parser;
        char *start_word = NULL;

        preInit(parser,file_character_prob,file_cond_prob,start_word);
        
        parser.start();
        
        postInit(start_word);
        
        if(start_word) {
            delete [] start_word;
        }
    }
    
    void Markov::initUniform(string alphabet) {
        uniform = true;
        for(unsigned int i=0; i < alphabet.size(); ++i) {
            ind.addIndex(alphabet[i]);
        }
        double p = 1.0 / ind.size;
        character_prob_rand_interval = new double[ind.size];
        for(int i=0; i< ind.size; ++i) {
            character_prob_rand_interval[i] = p;
        }
        cp_order = 0;
    }
    
    void Markov::postInit(const char *start_word) {
        last_k = new QueueFixedSizeRandomAccess<int>(cp_order, 0);
        for(int i=0; i<cp_order; ++i) {
            updateHistory(start_word[i]);
        }        
    }

    void Markov::preInit(ParameterParser &parser, 
                         const char *file_character_prob,
                         const char *file_cond_prob,
                         char *&start_word) {
        parser.requestCharacterDistribution(file_character_prob, ind, character_prob_rand_interval);
        parser.requestConditionalDistribution(file_cond_prob, ind, cp_order, 
                                              conditional_probability,
                                              start_word);
    }


    double Markov::getProbability(char c)
    {
        int index = ind.getIndex(c);

        if(cp_order == 0 || (int)last_k->size < cp_order)
        {
            return character_prob_rand_interval[index];
        }
        else {
            double *p = conditional_probability->get((*last_k).end-cp_order);
            if(!p)
            {
                return character_prob_rand_interval[index];
            }
            else {
                double sum = 0;
                for(int i=0; i<ind.size;++i)
                    sum+=p[i];
                return p[index]/sum;
            }
        }

    }



    void Markov::updateHistory(char c)
    {
        if(cp_order > 0) {
            last_k->push_back(ind.getIndex(c));
        }
    }


    int Markov::generateCharacter()
    {
        return generateCharacter(-1);
    }

    int Markov::generateCharacter(int excluded_char)
    {
        int excluded_char_index = -1;

        if(excluded_char!=-1)
            excluded_char_index = ind.getIndex( excluded_char);
        int index;

        if(cp_order == 0)
        {
            index = die.rollWithout(ind.size, character_prob_rand_interval, excluded_char_index);
        }
        else {
            double *p = conditional_probability->get((*last_k).end-cp_order);
            
            
            if(!p)
            {
                index = die.rollWithout(ind.size, character_prob_rand_interval, excluded_char_index);
            }
            else {
                index = die.rollWithout(ind.size, p, excluded_char_index);
            }
        }
        if(index>-1)
        {
            return (unsigned char)ind.getValue(index);
        }
        else
        {
            return -1;
        }
    }

    void Markov::generateSequence(long long length)
    {
        for(long long l=0;l<(long long)cp_order;++l)
        {
            write(ind.getValue((*last_k)[l]));
        }

        for(long long l=cp_order;l<length;++l)
        {
            char c = (char)generateCharacter();
            write(c);
            updateHistory(c);
        }
    }

    void Markov::generate(long long length,  map<string,string> &parameters)
    {
        if(!uniform) {
            map<string,string>::iterator it;

            const char *file_character_prob = NULL;
            const char *file_cond_prob = NULL;

            if( (it = parameters.find("character_distribution"))!=parameters.end()) {
                file_character_prob = it->second.c_str();
            }
            

            if( (it = parameters.find("qgram_distribution"))!=parameters.end()) {
                file_cond_prob = it->second.c_str();
            }
            
            init(file_character_prob, file_cond_prob);
        }
        generateSequence(length);

    }

}

