#include "analyze_setting.h"

using namespace std;

namespace papi
{

    bool AnalyzeSetting::getBool(string setting, bool default_value)
    {
        map<string,string>::iterator pref = settings_module->find(setting);
        if(pref!=settings_module->end())
        {
            if(pref->second=="1" || pref->second=="true")
                return true;
            else if(pref->second=="0" || pref->second=="false")
                return false;
            else
            {
                cerr << "Illegal value for setting "<<setting<<endl;
                exit(EXIT_FAILURE);
            }
        }
        pref = settings_general->find(setting);
        if(pref!=settings_general->end())
        {
            if(pref->second=="1" || pref->second=="true")
                return true;
            else if(pref->second=="0" || pref->second=="false")
                return false;
            else
            {
                cerr << "Illegal value for setting "<<setting<<endl;
                exit(EXIT_FAILURE);
            }
        }
        (*settings_module)[setting] = default_value ? "1" : "0";
        return default_value;
    }
    int AnalyzeSetting::getInt(string setting, int default_value)
    {
        map<string,string>::iterator pref = settings_module->find(setting);
        if(pref!=settings_module->end())
        {
            return atoi(pref->second.c_str());
        }
        pref = settings_general->find(setting);
        if(pref!=settings_general->end())
        {
            return atoi(pref->second.c_str());
        }
        (*settings_module)[setting] = convertToString(default_value);
        return default_value;
    }
    double AnalyzeSetting::getDouble(string setting, double default_value)
    {
        map<string,string>::iterator pref = settings_module->find(setting);
        if(pref!=settings_module->end())
        {
            return atof(pref->second.c_str());
        }
        pref = settings_general->find(setting);
        if(pref!=settings_general->end())
        {
            return atof(pref->second.c_str());
        }
        (*settings_module)[setting] = convertToString(default_value);
        return default_value;
    }
    long int AnalyzeSetting::getLong(string setting, long int default_value)
    {
        map<string,string>::iterator pref = settings_module->find(setting);
        if(pref!=settings_module->end())
        {
            return atol(pref->second.c_str());
        }
        pref = settings_general->find(setting);
        if(pref!=settings_general->end())
        {
            return atol(pref->second.c_str());
        }
        (*settings_module)[setting] = convertToString(default_value);
        return default_value;
    }

    string AnalyzeSetting::getString(string setting, string default_value)
    {
        map<string,string>::iterator pref = settings_module->find(setting);
        if(pref!=settings_module->end())
        {
            return pref->second;
        }
        pref = settings_general->find(setting);
        if(pref!=settings_general->end())
        {
            return pref->second;
        }
        (*settings_module)[setting] = default_value;
        return default_value;
    }

    char AnalyzeSetting::getChar(string setting, char default_value)
    {
        map<string,string>::iterator pref = settings_module->find(setting);
        if(pref!=settings_module->end())
        {
            return pref->second[0];
        }
        pref = settings_general->find(setting);
        if(pref!=settings_general->end())
        {
            return pref->second[0];
        }
        (*settings_module)[setting] = convertToString(default_value);
        return default_value;
    }
}

