#include "csv_out_stream.h"

namespace papi
{
    CsvOutStream::CsvOutStream(bool decimalPoint):
    last_col(-1)
    {
        init(decimalPoint);
        
    }

    CsvOutStream::CsvOutStream():last_col(-1)
    {}
    
    void CsvOutStream::addStream(ostream *s) {
        streams.push_back(s);
        s->imbue(l);
        s->precision(18);
    }

    void CsvOutStream::init(bool decimalPoint)
    {
        if(decimalPoint == COMMA)
        {
            locale l_std = locale();
            l = locale(l_std, new CommaAsDecimalPoint(l_std.name().c_str()));
        }
        streams.clear();
    }


    void CsvOutStream::skipCell(int num)
    {
        for(int i=0;i<num;++i)
            addCell("");
    }

    string CsvOutStream::getFormattedChar(char c)
    {
        if(isspace(c))
        {
            switch(c)
            {
                case ' ': return " ";break;
                case '\t': return "\\t";break;
                case '\n': return "\\n";break;
                case '\v': return "\\v";break;
                case '\f': return "\\f";break;
                case '\r': return "\\r";break;
                default: return char2hex(c);
            }
        }
        else if (!isgraph(c)){
            return char2hex(c); 
        }
        else {
            switch(c)
            {
                case '"': return "\"\"";break;
                case '\\': return "\\\\";break;
                default: return string(&c,1);
            }
        }
    }

    void CsvOutStream::printFormatted(char const* s)
    {
        write('"');
        int i = 0;
        while(char c = s[i++])
        {
            write(getFormattedChar(c));
        }
        write('"');
    }

    void CsvOutStream::printFormatted(char c)
    {
        write('"');
        write(getFormattedChar(c));
        write('"');
    }

    void CsvOutStream::printFormatted(string s)
    {
        printFormatted(s.c_str());
    }

  
    void CsvOutStream::newline()
    {
        for(list<ostream*>::iterator it = streams.begin();it!=streams.end();++it) {
            ostream *stream = *it;
            (*stream) << endl;
        }
        last_col=-1;
    }


    void CsvOutStream::addCell(char const* text)
    {
        ++last_col;
        if(last_col > 0)
            write(";");
        printFormatted(text);
    }


    void CsvOutStream::addCell(string text)
    {
        addCell(text.c_str());
    }

    void CsvOutStream::addCell(char c)
    {
        ++last_col;
        if(last_col > 0)
            write(";");
        printFormatted(c);
    }

}

