#include "hash_map.h"

namespace papi
{

    bool eq::pair_unsigned_cstring_int::operator()(const pair<unsigned char const*,int>&a, const pair<unsigned char const*,int>&b) const {
        
        const unsigned char *a_str = a.first, *b_str=b.first;
        if(a.second!=b.second)
            return false;
        int length = a.second;
        
        
        for(int i=0;i<length;++i)
            if(*a_str++!=*b_str++)
                return false;
        return true;
    }


    bool eq::fixed_length::operator()( unsigned char const *a,  unsigned char const *b)  const{
        
        for(int i=0;i<length;++i)
        {
            if(*a++ != *b++)
                return false;
        }
        return true;
    }

    long long hash_djb2::fixed_length::operator()( unsigned char const *str) const{
        long long hash = 5381;
        long long c;
        for(int i=0;i<length;++i)
        {
            c = *str++;
            hash = ((hash << 5) + hash) ^ c; /* hash * 33 XOR c */
        }
        
        return hash;
    }

    long long hash_djb2::pair_unsigned_cstring_int::operator()(const pair<unsigned char const*,int>&str) const {
        long long hash = 5381;
        unsigned char const* s=str.first;
        int length = str.second;
        long long c;
        for(int i=0;i<length;++i)
        {
            c = *s++;    
            hash = ((hash << 5) + hash) ^ c; /* hash * 33 XOR c */
        }
        return hash;
    }
}

