#include "random.h"

#include <boost/random.hpp>
#include <ctime>

using namespace std;


namespace papi
{

    RandomDouble::RandomDouble(): generator(NULL)
    {
    }

    RandomDouble::RandomDouble(double min, double max) : generator(NULL)
    {
        init(min,max);
    }

    RandomDouble::~RandomDouble()
    {
        if(generator) {
            delete generator;
            generator = NULL;
        }
    }

    double RandomDouble::generate()
    {
        if(generator == NULL)
        {
            cerr << "Random number generator not initalized" << endl;
            exit(EXIT_FAILURE);
        }
        return (*generator)();
    }

    void RandomDouble::init(double min, double max)
    {
        if(generator) {
            delete generator;
        }
        std::ifstream r;
        r.open("/dev/urandom");
        int s = r.get();
        r.close();
        generator = new boost::variate_generator<boost::mt19937, boost::uniform_real<> >(boost::mt19937(static_cast<unsigned int>(s)), boost::uniform_real<>(min,max));
    }


    int Die::roll(int num, const double *prob)
    {
        return rollWithout(num, prob, -1);
    }
    int Die::rollWithout(int num, const double *prob, int excludedIndex)
    {
        double sum = 0;
        int index;
        for(int i=0;i<num;++i)
            if(i!=excludedIndex)
                sum+=prob[i];
        if(sum == 0)
            return -1;
        
        //Normalize
        double p = random.generate()*sum;
        
        //Skip excluded index
        for(index = 0;index<excludedIndex;++index)
        {
            if(p<prob[index])
                return index;
            p-=prob[index];
        }
        for(index = excludedIndex+1;index<num-1;++index)
        {
            if(p<prob[index])
                return index;
            p-=prob[index];
        }
        
        // this should not happen and it is only possible due to rounding errors
        
        // default case
        if(index<num)
            return index;
        // if excludedIndex was the last index
        else
            return num-2;
        
    }
}


