#include "string_utils.h"

using namespace std;

namespace papi
{

    void trimSpaces(string &str)
    {
        int startpos = str.find_first_not_of(" \t\n\v\f\r");
        int endpos = str.find_last_not_of(" \t\n\v\f\r");
        
        if(( (int)string::npos == startpos ) || ( (int)string::npos == endpos))
            str = "";
        else
            str = str.substr( startpos, endpos-startpos+1 );
    }


    string char2hex(char c)
    {
        char conv[] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
        string res = "\\xXX";
        res[2] = conv[(unsigned char)c >> 4];
        res[3] = conv[(unsigned char)c & 0x0f];
        return res;
    }
    
    char hex2char(string s) {
        char res = 0;
        if(s.size() == 4) {
            s = s.substr(2,4);
        }
        for(int i=0; i<2;++i) {
            res<<=4;
            char c= toupper(s[i]);
            if( '0'<=c && c<='9' ) {
                res|=(c-'0');
            } else {
                res |= (c-'A'+10);
            }
        }
        return res;
    }

}

