#ifndef _string_utils_h_
#define _string_utils_h_

#include <sstream>
#include <string>

#define CHAR_ANZ (CHAR_MAX-CHAR_MIN+1)


using namespace std;


namespace papi
{

    /// Remove whitespaces at the beginning and the end
    void trimSpaces(string&);

    /**
     * Value to string
     * @param[in] data The value
     * @return String representation of the value
     */
    template<class T>
    string convertToString(T data)
    {
        stringstream str(stringstream::out);
        str << data;
        return str.str();
    }

    /**
     * Get hexcode of a character in the form \\x00
     * @param[in] c The character
     * @return Hexcode as a string
     */
    string char2hex(char c);
    
    /**
     * Get character of a hexcode in the form \\x00 or XX.
     * @param[in] s The hexcode
     * @return The corresponding character
     */
    char hex2char(string s);
    
}

#endif

