/*

- alignment
+ assignValue                basic_iterator.h
+ atBegin                    basic_iterator.h
* atEnd
+ childrenAreLeaves          index_esa_stree.h
+ container                  index_esa_stree.h
* countChildren
* countOccurrences
+ emptyParentEdge            index_esa_stree.h
- getFrequency
* getOccurrence
- getOccurrences
- getOccurrencesBWT
+ getValue                   basic_iterator.h
+ goBegin                    index_esa_stree.h
+ goDown                     index_esa_stree.h
- goEnd
+ goFurther                  basic_iterator.h
+ goNext                     index_esa_stree.h
+ goPrevious                 basic_iterator.h
+ goRight                    index_esa_stree.h
+ goUp                       index_esa_stree.h
+ isLeaf                     index_esa_stree.h
- isLeftMaximal
- isPartiallyLeftExtensible
+ isRightTerminal            index_esa_stree.h
* isRoot
- isUnique
* lca
* lcp
+ moveValue                  basic_iterator.h
+ nodeHullPredicate          index_esa_stree.h
+ nodePredicate              index_esa_stree.h
+ parentEdgeFirstChar        index_esa_stree.h
+ parentEdgeLabel            index_esa_stree.h
+ parentEdgeLength           index_esa_stree.h
+ parentRepLength            index_esa_stree.h
+ position                   basic_iterator.h
* repLength
+ representative             index_esa_stree.h
+ value                      index_esa_stree.h

* goRoot
* clear
* nodeUp
* _goDown
* _goUp
* _goRight
* _isLeaf
- goNextImpl

TODO: Warum werden bei der Vererbung nicht index und vDesc vererbt?
TODO: Zwei Iteratoren: TopDown und BottumUp (Unterscheiden sich vor allem in goNext?)
TODO: Iterator-Klasse ohne ParentLinks, dafr sowohl TopDown als auch BottomUp  (Notiz vom SeqAn-Retreat)
TODO: goDown und representative vertragen sich nicht mit "Fibre &" (und bei Fibre ohne & strzt das Programm ab)

*/


// ==========================================================================
//                             index_suffix_trees
// ==========================================================================
// Copyright (c) 2006-2011, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================
// Author: Andre Dau <dau@in.tum.de>
// Author: Johannes Krugel <krugel@in.tum.de>
// ==========================================================================
// Suffix tree interface for IndexDigest.
// ==========================================================================

#ifndef SANDBOX_TUM_INCLUDE_SEQAN_INDEX_SUFFIX_TREE_INDEX_DIGEST_STREE_H_
#define SANDBOX_TUM_INCLUDE_SEQAN_INDEX_SUFFIX_TREE_INDEX_DIGEST_STREE_H_

namespace seqan {

/*
template <typename TIndex, typename TSize>
struct VertexDigest_ {
    typedef typename TIndex::TSuffixTrees                   TSuffixTrees;
    typedef String<typename TIndex::TNode>                  TNodes;
    typedef typename Size<TSuffixTrees>::Type               TSuffixTreesSize;
    typedef typename Size<TNodes>::Type                     TNodesSize;
    
    TSuffixTreesSize treeIndex;
    TNodesSize nodeIndex;

    // TODO: range weg?  (Kann sich nmlich auch auf mehrere Bume erstrecken)
    // TODO: parentRight weg
    Pair<TSize> range;          // current SA interval of hits
    TSize       parentRight;    // right boundary of parent node's range (allows to go right)

    VertexDigest_() {}
     
    VertexDigest_(MinimalCtor):
        range(0, 0),
        parentRight(0) {}
     
    VertexDigest_(TSize otherRangeLeft, TSize otherRangeRight, TSize otherParentRight):
        range(Pair<TSize>(otherRangeLeft, otherRangeRight)),
        parentRight(otherParentRight) {}
     
    VertexDigest_(Pair<TSize> const &otherRange, TSize otherParentRight):
        range(otherRange),
        parentRight(otherParentRight) {}
     
    VertexDigest_(VertexDigest_ const &other):
        range(other.range),
        parentRight(other.parentRight) {}
};

//////////////////////////////////////////////////////////////////////////////
///.Metafunction.VertexDescriptor.param.T.type:Spec.IndexDigest

template <typename TText, typename TSpec>
struct VertexDescriptor<Index<TText, IndexDigest<TSpec> > > {
    typedef typename Size<Index<TText, IndexDigest<TSpec> > >::Type TSize;
    typedef VertexDigest_<Index<TText, IndexDigest<TSpec> >, TSize> Type;
};

template <typename TText, typename TIndexSpec, typename TSpec>
class Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec> > > >:
    public Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<> > >
{
public:
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef Iter<TIndex, VSTree<TopDown<> > >               TBase;
    typedef typename VertexDescriptor<TIndex>::Type         TVertexDesc;

    TIndex const    *index;        // container of all necessary tables
    TVertexDesc     vDesc;        // current interval in suffix array and

    Iter(TIndex &_index):
        TBase(_index),
        index(&_index)
    {
        vDesc = indexCST(*index)->root();
        _indexRequireTopDownIteration(_index);
    }

    Iter(TIndex &_index, MinimalCtor):
        TBase(_index),
        index(&_index),
        vDesc(0) {}

    Iter(TIndex &_index, TVertexDesc const &_vDesc):
        TBase(_index),
        index(&_index),
        vDesc(_vDesc)
    {
        _indexRequireTopDownIteration(_index);
    }

    Iter(Iter const &_origin):
        TBase(container(_origin)),
        index(&container(_origin)),
        vDesc(value(_origin)) {}

};

template <typename TText, typename TIndexSpec, class TSpec>
inline void clear(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > &it) 
{
    value(it) = indexCST(container(it))->root();
}

template <typename TText, typename TIndexSpec, class TSpec>
inline void goRoot(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > &it) 
{
    clear(it);
}

// is this a leaf?
// TODO including empty $-edges
template <typename TText, typename TIndexSpec, class TSpec, typename TDFSOrder>
inline bool _isLeaf(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it,
    VSTreeIteratorTraits<TDFSOrder, False> const)
{
    return indexCST(container(it))->isleaf(value(it));
}

// is this a leaf?
// TODO ignoring empty $-edges
template <typename TText, typename TIndexSpec, class TSpec, typename TDFSOrder>
inline bool _isLeaf(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it,
    VSTreeIteratorTraits<TDFSOrder, True> const)
{
    return indexCST(container(it))->isleaf(value(it));
}

template <typename TText, typename TIndexSpec, class TSpec>
inline bool isRoot(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it) 
{
    return indexCST(container(it))->root() == value(it);
}

//    template <typename TSize>
//    inline bool _isRoot(VertexDigest_<TSize> const &value) {
//    }

// return vertex descriptor of parent's node
template <typename TText, typename TIndexSpec, class TSpec>
inline typename VertexDescriptor<Index<TText, IndexDigest<TIndexSpec> > >::Type
nodeUp(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec> > > > const &it) 
{
    if (isRoot(it))
        return value(it);
    else
        return indexCST(container(it))->parent(value(it));
}

template <typename TText, typename TIndexSpec, class TSpec>
inline bool 
_goUp(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec> > > > &it) 
{
    if (isRoot(it))
        return false;

    value(it) = nodeUp(it);
    return true;
}

// go right to the lexic. next sibling
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder, typename THideEmptyEdges>
inline bool _goRight(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > &it, 
    VSTreeIteratorTraits<TDFSOrder, THideEmptyEdges> const) 
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef typename VertexDescriptor<TIndex>::Type         TVertexDesc;

    if (isRoot(it))
        return false;        

    TVertexDesc sibling = indexCST(container(it))->sibling(value(it));
    if (sibling == 0)
        return false;

    value(it) = sibling;

    return true;
}

// go down the leftmost edge
// TODO including empty $-edges ?
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder>
inline bool _goDown(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > &it,
    VSTreeIteratorTraits<TDFSOrder, False> const)
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    if (_isLeaf(it, EmptyEdges())) return false;
    value(it) = indexCST(container(it))->firstChild(value(it));
    return true;
}

// go down the leftmost edge
// TODO skipping empty $-edges ?
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder>
inline bool _goDown(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > &it,
    VSTreeIteratorTraits<TDFSOrder, True> const)
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    if (_isLeaf(it, EmptyEdges())) return false;
    value(it) = indexCST(container(it))->firstChild(value(it));
    return true;
}

template <typename TText, class TIndexSpec, class TSpec>
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type 
countChildren(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it) 
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef typename VertexDescriptor<TIndex>::Type         TVertexDesc;
    typedef typename Size<TIndex>::Type                     TSize;

    if (_isLeaf(it, EmptyEdges())) return 0;

    TSize result = 1;
    for (TVertexDesc child = indexCST(container(it))->firstChild(value(it));
        child != 0;
        child = indexCST(container(it))->sibling(child)
    ) {
        ++result;
    }
    return result;
}

template <typename TText, class TIndexSpec, class TSpec>
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type 
countOccurrences(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it) 
{
    return indexCST(container(it))->numberofleaves(value(it));
}

template <typename TText, class TIndexSpec, class TSpec>
inline bool atEnd(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > &it) 
{
    return atEnd(it, container(it));    
}

template <typename TText, typename TIndexSpec>
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type
repLength(Index<TText, IndexDigest<TIndexSpec> > const &index, typename VertexDescriptor<Index<TText, IndexDigest<TIndexSpec> > >::Type const &vDesc) 
{
    return indexCST(index)->depth(vDesc);
}

template <typename TText, typename TIndexSpec, typename TSpec>
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type
repLength(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<TSpec> > > const &it) 
{
    return repLength(container(it), value(it));
}

template <typename TText, typename TIndexSpec, typename TSpec>
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type
repLength(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<BottomUp<TSpec> > > const &it) 
{
    return repLength(container(it), value(it));
}

// get the node of the subtree under the edge beginning with character c
template <typename TText, class TIndexSpec, class TSpec, typename TValue>
inline bool 
_getNodeByChar(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it, 
    TValue c, 
    typename VertexDescriptor<Index<TText, IndexDigest<TIndexSpec> > >::Type &childDesc)
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef typename Size<TIndex>::Type                     TSize;

    if (_isLeaf(it, EmptyEdges())) return false;

    childDesc = indexCST(container(it))->child(value(it), c);
    if (childDesc == 0) return false;
    return true;
}

// go down the edge beginning with c (returns false iff this edge doesn't exists)
template <typename TText, typename TIndexSpec, class TSpec, typename TValue>
inline bool _goDownChar(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<TSpec> > > &it, TValue c) 
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef typename VertexDescriptor<TIndex>::Type         TVertexDesc;
    TVertexDesc nodeDesc;
    if (_getNodeByChar(it, c, nodeDesc)) {
        value(it) = nodeDesc;
        return true;
    }
    return false;
}

template <typename TText, typename TIndexSpec, class TSpec>
inline typename SAValue<Index<TText, IndexDigest<TIndexSpec> > >::Type 
getOccurrence(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TSpec> > const &it) {
    return indexCST(container(it))->textpos(value(it));
}

template <typename TText, typename TIndexSpec, class TSpec1, class TSpec2 >
inline bool lca(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec1> > > > &a, 
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec2> > > > &b, 
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec1> > > > &_lca)
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef typename VertexDescriptor<TIndex>::Type         TVertexDesc;
    TVertexDesc nodeDesc = indexCST(container(a))->lca(value(a), value(b));
    _lca = Iter<TIndex, VSTree<TopDown<ParentLinks<TSpec1> > > >(container(a), nodeDesc);

    if (nodeDesc == 0) return false;
    else return true;
}

// return the lcp of a and b by seeking the lca of them
template <typename TText, typename TIndexSpec, class TSpec1, class TSpec2 >
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type lcp(
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec1> > > > &a, 
    Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec2> > > > &b) 
{
    typedef Index<TText, IndexDigest<TIndexSpec> >          TIndex;
    typedef typename VertexDescriptor<TIndex>::Type         TVertexDesc;
    TVertexDesc nodeDesc = indexCST(container(a))->lca(value(a), value(b));
    return indexCST(container(a))->depth(nodeDesc);
}

template <typename TText, class TIndexSpec, class TSpec>
inline typename Size<Index<TText, IndexDigest<TIndexSpec> > >::Type
parentEdgeLength(Iter<
    Index<TText, IndexDigest<TIndexSpec> >, 
    VSTree<TopDown<TSpec> > > const &it) 
{
    return repLength(it) - parentRepLength(it);
}

//*/

//    template <typename TText, typename TSpec>
//    void _indexRequireTopDownIteration(Index<TText, IndexDigest<TSpec> > &index) 
//    {
//         indexRequire(index, DigestSTrees());
//         indexRequire(index, DigestDivider());
//    }
//    
//    //////////////////////////////////////////////////////////////////////////////
//    // history stack functions
//    
//    template <typename TSize>
//    struct HistoryStackDigest_
//    {
//    };
//     
//    template <typename TText, typename TIndexSpec, typename TSpec>
//    struct HistoryStackEntry_<Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec> > > > > 
//    {
//        typedef Index<TText, IndexDigest<TIndexSpec> >  TIndex;
//        typedef typename Size<TIndex>::Type             TSize;
//        typedef HistoryStackDigest_<TSize>              Type;
//    };
//     
//    template <typename TText, typename TIndexSpec, typename TSpec >
//    inline void 
//    _historyPush(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<TSpec> > > &it) 
//    {
//    }
// 
//  //////////////////////////////////////////////////////////////////////////////
//  ///.Function.resizeVertexMap.type:Spec.IndexDigest
//     
//    template <typename TText, typename TIndexSpec, typename TPropertyMap>
//    inline void
//    resizeVertexMap(Index<TText, IndexDigest<TIndexSpec> > const& index, TPropertyMap & pm) 
//    {
//      resize(pm, length(indexDir(index)), Generous());
//    }
//     
//    template <typename TSize>
//    inline typename Id<VertexDigest_<TSize> const >::Type
//    _getId(VertexDigest_<TSize> const &desc) 
//    {
//    }
//     
//    template <typename TSize>
//    inline typename Id<VertexDigest_<TSize> const>::Type
//    _getId(VertexDigest_<TSize> &desc) 
//    {
//    }
//     
//    // adjust iterator's right border of SA range
//    template <typename TText, typename TIndexSpec, typename TSpec>
//    inline void
//    _adjustRightBorder(Iter<Index<TText, IndexDigest<TIndexSpec> >, VSTree<TopDown<TSpec> > > &it)
//    {
//    }

}  // namespace seqan

#endif  // SANDBOX_TUM_INCLUDE_SEQAN_INDEX_SUFFIX_TREE_INDEX_DIGEST_STREE_H_
